// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AppParCurves_MultiBSpCurve_HeaderFile
#define _AppParCurves_MultiBSpCurve_HeaderFile

#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _AppParCurves_MultiCurve_HeaderFile
#include <AppParCurves_MultiCurve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TColStd_HArray1OfReal;
class TColStd_HArray1OfInteger;
class Standard_OutOfRange;
class Standard_DimensionError;
class Standard_ConstructionError;
class AppParCurves_Array1OfMultiPoint;
class TColStd_Array1OfReal;
class TColStd_Array1OfInteger;
class AppParCurves_MultiCurve;
class gp_Pnt;
class gp_Pnt2d;
class gp_Vec;
class gp_Vec2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class describes a MultiBSpCurve approximating a Multiline. <br>
//!    Just as a Multiline is a set of a given number of lines, a MultiBSpCurve is a set <br>
//! of a specified number of bsplines defined by: <br>
//! -   A specified number of MultiPoints - the poles of a specified number of curves <br>
//! -   The degree of approximation identical for each of the specified number of curves. <br>
class AppParCurves_MultiBSpCurve  : public AppParCurves_MultiCurve {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! returns an indefinite MultiBSpCurve. <br>
Standard_EXPORT AppParCurves_MultiBSpCurve();

//! creates a MultiBSpCurve, describing BSpline curves all <br>
//!          containing the same number of MultiPoint. <br>
//!          An exception is raised if Degree < 0. <br>
Standard_EXPORT AppParCurves_MultiBSpCurve(const Standard_Integer NbPol);

//! creates a MultiBSpCurve, describing BSpline curves all <br>
//!          containing the same number of MultiPoint. <br>
//!          Each MultiPoint must have NbCurves Poles. <br>
Standard_EXPORT AppParCurves_MultiBSpCurve(const AppParCurves_Array1OfMultiPoint& tabMU,const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Mults);

//! creates a MultiBSpCurve, describing BSpline <br>
//!          curves, taking control points from <SC>. <br>
Standard_EXPORT AppParCurves_MultiBSpCurve(const AppParCurves_MultiCurve& SC,const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Mults);

//! Knots of the multiBSpCurve are assigned to <theknots>. <br>
Standard_EXPORT   void SetKnots(const TColStd_Array1OfReal& theKnots) ;

//! Multiplicities of the multiBSpCurve are assigned <br>
//!          to <theMults>. <br>
Standard_EXPORT   void SetMultiplicities(const TColStd_Array1OfInteger& theMults) ;

//! Returns an array of Reals containing <br>
//! the multiplicities of curves resulting from the approximation. <br>
Standard_EXPORT  const TColStd_Array1OfReal& Knots() const;

//! Returns an array of Reals containing the <br>
//!  multiplicities of curves resulting from the approximation. <br>
Standard_EXPORT  const TColStd_Array1OfInteger& Multiplicities() const;

//! returns the degree of the curve(s). <br>
Standard_EXPORT virtual  Standard_Integer Degree() const;

//! returns the value of the point with a parameter U <br>
//!          on the BSpline curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 2d. <br>
Standard_EXPORT virtual  void Value(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt& Pt) const;

//! returns the value of the point with a parameter U <br>
//!          on the BSpline curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 3d. <br>
Standard_EXPORT virtual  void Value(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt2d& Pt) const;

//! returns the value of the point with a parameter U <br>
//!          on the BSpline curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 3d. <br>
Standard_EXPORT virtual  void D1(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt& Pt,gp_Vec& V1) const;

//! returns the value of the point with a parameter U <br>
//!          on the BSpline curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 2d. <br>
Standard_EXPORT virtual  void D1(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt2d& Pt,gp_Vec2d& V1) const;

//! returns the value of the point with a parameter U <br>
//!          on the BSpline curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 3d. <br>
Standard_EXPORT virtual  void D2(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt& Pt,gp_Vec& V1,gp_Vec& V2) const;

//! returns the value of the point with a parameter U <br>
//!          on the BSpline curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 2d. <br>
Standard_EXPORT virtual  void D2(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt2d& Pt,gp_Vec2d& V1,gp_Vec2d& V2) const;

//! Prints on the stream o information on the current <br>
//!          state of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT virtual  void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TColStd_HArray1OfReal myknots;
Handle_TColStd_HArray1OfInteger mymults;
Standard_Integer myDegree;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
