#! /usr/bin/perl
#* ============================================================
# * File        : tvlinks/video.pl
# * Version     : 0.1
# * Author      : 
# * Date        : 2007 sept
# * Description: parser for tvlinks.co.uk
# *
# * Requires:
# * - mythstream v0.17_2 http 30x (and cookie?) handling
# *
# * ============================================================ */

use English;
use XML::DOM;
use HTML::Entities;

#------------------------------------------------------------------------------
# Init
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line
$surl= $in[1]; # stream item url
$sname= $in[2]; # stream item name

# remove quotes from sname
$sname =~ s/^\"?(.*?)\"?$/$1/;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# read file into $data
#------------------------------------------------------------------------------

$datafile = $source;
open( INFO, "<$datafile" );      # Open file for reading
undef $/;
$data = <INFO>;                 # Read all
close(INFO);

#------------------------------------------------------------------------------
# Parse playlist
#------------------------------------------------------------------------------




# &dump_lines();

#<param name="movie" value="http://www2.tv-links.co.uk/video/9/8011/12996/7..6/11..1/once/c0...398303cb6f6b1">
# or
# <param name="flashvars" value="config={videoFile: 'http://www2.tv-links.co.uk/video/...........
my $a, $b;

if ( ($a, $b) = $data =~ /(http:\/\/[^\.]+\.tv-links\.co\.uk\/video\/[^'"]+)["']/ )
{
      $url = "$a";

      $item = $doc->createElement('item');
      $root->appendChild($item);
      
      $item->appendChild( newNode('name', "play $sname") );
      $item->appendChild( newNode('url',  $url) );
      $item->appendChild( newNode('descr', "") );
      $item->appendChild( newNode('handler', "") );
      
      $item = $doc->createElement('item');
      $root->appendChild($item);
      
      $item->appendChild( newNode('name', "download $sname") );
      $item->appendChild( newNode('url',  $url) );
      $item->appendChild( newNode('descr', "") );
      $item->appendChild( newNode('handler', "FUZZY_DL") );
}

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse 
{
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}



