#!/usr/bin/perl -w

# * ============================================================
# * File  : apple.pl
# * Author: Michael Knoll <michael.knoll@gmail.com
# * Date  : 2005-07-20
# * Description : Parses Apple Movie Trailers and Catagories
# *
# * Copyright 2005 by Michael Knoll
#
# * This program is free software; you can redistribute it
# * and/or modify it under the terms of the GNU General
# * Public License as published bythe Free Software Foundation;
# * either version 2, or (at your option)
# * any later version.
# *
# * This program is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# * GNU General Public License for more details.
# *
# * ============================================================ 

use HTML::Parser;
use LWP::UserAgent;
use XML::DOM;
use XML::XQL;
use XML::XQL::DOM;

my $USER_AGENT = 'iTunes/4.7';

my $HANDLER = "*apple";

my $BASE_URL = 'http://www.apple.com';
my $START_URL = '/moviesxml/h/index.xml';
my $MAIN_INDEX_URL = $BASE_URL . $START_URL;

my %stream_names = (
			"large.xml" => "Large",
			"medium.xml" => "Medium" ,
			"small.xml" => "Small",
			);



my $line = $ARGV[1];

my $command;
my $url;

if(defined $line and $line =~ /^(.*?):(.*)$/)
{
	$command = $1;
	$url = $2;
}
else
{
	$command = 'start';
	$url = $MAIN_INDEX_URL;
}

my $output_doc = XML::DOM::Document->new;
my $output_head = $output_doc->createXMLDecl ('1.0');
my $output_items = $output_doc->createElement('items');

my $ua = new LWP::UserAgent(agent => $USER_AGENT);

my $response = $ua->request(HTTP::Request->new(GET => $url));

if(!$response->is_success)
{
	print STDERR $response->status_line, "\n";
	exit(0);
}
   print "RESPONSE1:\n$response\n";

my $parser = new XML::DOM::Parser;
my $maindoc = $parser->parse($response->content);

if($command eq 'start')
{
	my $ROOT_XQL = '/Document/ScrollView/MatrixView/View/VBoxView[0]/MatrixView';

	my $CATAGORIES_XQL = $ROOT_XQL . '/VBoxView[0]/VBoxView[3]/MatrixView/View/VBoxView/HBoxView/TextView/GotoURL';
	my $EXCLUSIVE_XQL = $ROOT_XQL . '/VBoxView[2]/VBoxView[1]/MatrixView/View/VBoxView/MatrixView/VBoxView/HBoxView/GotoURL';
	my $EXCLUSIVE_TITLE_XQL = 'TextView/textNode()[0]';

	my $SOON_XQL = $ROOT_XQL . "/VBoxView[2]/VBoxView[\@viewName='Opening This Week']/VBoxView[1]/MatrixView/View/VBoxView/GotoURL";
	my $SOON_TITLE_XQL = 'TextView/B/textNode()[0]';

	trailers($maindoc, $EXCLUSIVE_XQL, $EXCLUSIVE_TITLE_XQL, "Exclusive - ");
	trailers($maindoc, $SOON_XQL, $SOON_TITLE_XQL, "Comming Soon - ");
	getCatagories($maindoc, $CATAGORIES_XQL);
}
elsif($command eq 'catagory')
{
	my $TRAILERS_XQL = '/Document/ScrollView/MatrixView/MatrixView/VBoxView/MatrixView/HBoxView/VBoxView/MatrixView/VBoxView/HBoxView/TextView/GotoURL';
	my $TRAILERS_TITLE_XQL = 'B/textNode()[0]';

	trailers($maindoc, $TRAILERS_XQL, $TRAILERS_TITLE_XQL, '');
}
elsif($command eq 'trailer')
{
	my $RATES_XQL = '//GotoURL';
	my $ROOT_XQL = '/Document/ScrollView/MatrixView/View/VBoxView/HBoxView/VBoxView/MatrixView/VBoxView/View/VBoxView';
	my $DESCRIPTION_XQL = $ROOT_XQL . '/TextView[1]/textNode()[0]';
	my $RELEASE_XQL = $ROOT_XQL . '/TextView[0]/SetFontStyle/textNode()[0]';

	my ($description_node) = ($maindoc->xql($DESCRIPTION_XQL));
	my $description = defined $description_node ? trimText($description_node->getData()) : ""; 

	my ($release_node) = ($maindoc->xql($RELEASE_XQL));
	my $release = defined $release_node ? trimText($release_node->getData()): "";

	my $desc = $release . "  " . $description;
	my @rate_urls;

	foreach my $trailers ($maindoc->xql($RATES_XQL))
	{
		my $sub_url = $trailers->getAttribute('url');

		findStream( URI->new($sub_url)->abs($url), $desc);
	}
}

print $output_head->toString;
print $output_items->toString;
print "\n";

sub getCatagories
{
	my $doc = shift;
	my $cat_xql = shift;

	foreach my $catagory ($doc->xql($cat_xql))
	{
		my $url = $BASE_URL . $catagory->getAttribute('url');
		my $catagory_title = "Catagory - " . trimText($catagory->getFirstChild()->getData());

		newItem(	name => $catagory_title,
				url => 'catagory:' . $url,
				handler => $HANDLER);
	}
}

sub trailers
{
	my $doc = shift;
	my $root_xql = shift;
	my $title_xql = shift;
	my $title_prepend = shift;

	foreach my $trailer ($doc->xql($root_xql))
	{
		next if $trailer->getAttribute('inhibitDragging');

		my $url = $BASE_URL . $trailer->getAttribute('url');

		my ($title_node) = ($trailer->xql($title_xql));
		my $title = $title_prepend . trimText($title_node->getData());

		newItem(	name => $title,
				url => 'trailer:' . $url,
				handler => $HANDLER);
	}
}

sub findStream
{
	my $url_src = shift;
	my $description = shift;

	my $response_mov = $ua->request(HTTP::Request->new(GET => $url_src));

	if(!$response_mov->is_success)
	{
		print STDERR $response_mov->status_line, "\n";
		exit(0);
	}

   print "RESPONSE:\n$response_mov\n";
   
	my $parser_mov = new XML::DOM::Parser;

	my $maindoc_mov = $parser_mov->parse($response_mov->content);

	my $MOVIE_XQL = '/Document/ScrollView/MatrixView/VBoxView/HBoxView/View/MovieView';
	$MOVIE_XQL = '//MovieView';

	foreach my $trailers ($maindoc_mov->xql($MOVIE_XQL))
	{
		my $url = $trailers->getAttribute('url');

		my $title;

		my $stream = $url_src;
		$stream =~ s/^.*\///;

		if( defined $stream_names{$stream})
		{
			$title = $stream_names{$stream};
		}
		$stream =~ s/\.xml$//;

		if( !$title )
		{
			$title = $stream;
		}

		newItem(	name => $title,
				url => $url,
				descr => $description);
	}
}

sub trimText
{
	my $text = shift;

	$text =~ s/^\s+//;
	$text =~ s/\s+$//;

	return $text;
}

sub newItem
{
	my %elements = @_;

	my $new_item = $output_doc->createElement('item');
	$output_items->appendChild($new_item);

	foreach(keys %elements)
	{
		my $node = $output_doc->createElement($_);
		my $text = $output_doc->createTextNode($elements{$_});
		$node->appendChild($text);
		$new_item->appendChild( $node );
	}
}

