/* ============================================================
 * File  : main.cpp
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description : leaned heavily on mythnews plugin source,
 *               mythnews copyright Renchi Raju
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#include <iostream>

#include <qapplication.h>
#include <unistd.h>


#include "mythstream.h"
#include "../libs/streamconfig.h"
#include "../libs/storageconfig.h"

#include <mythtv/mythcontext.h>
#include <mythtv/mythdialogs.h>
#include <mythtv/mythmedia.h>
#include <mythtv/mythplugin.h>
#include <mythtv/libmythui/myththemedmenu.h>

using namespace std;

void MyCallback(void*, QString &selection)
{
    QString sel = selection.lower();
    QString error;
    ValueList values;

    StreamStorage *streamStorage = new StreamStorage( "streams", "mythstream" );
    ReposStorage *repos = new ReposStorage();

    selectStorages(repos, streamStorage);

    if ( !streamStorage->loadList(0, error) )
       cerr << error << endl;

    if (sel == "stream_config")
    {
       StreamConfig config(gContext->GetMainWindow(), "stream", streamStorage, repos);
       config.exec();
    }
    else if (sel == "storage_config")
    {
       StorageConfig config(gContext->GetMainWindow(), "storage", streamStorage, repos);
       config.exec();
    }

    delete streamStorage;
    delete repos;

}


void runMenu(QString themedir, const QString &which_menu)
{
    MythThemedMenu *diag = new MythThemedMenu( themedir.ascii(), which_menu,
					gContext->GetMainWindow()->GetMainStack( ), "stream menu");

    QString data;

    diag->setCallback(MyCallback, &data);
    diag->setKillable();

    if (diag->foundTheme())
    {
        GetMythMainWindow()->GetMainStack()->AddScreen(diag);
    }
    else
        cerr << "Couldn't find theme " << themedir << endl;

}

extern "C"
{
int mythplugin_init(const char *libversion);
int mythplugin_run(void);
int mythplugin_config(void);
}


void runStream(void);

void setupKeys(void)
{
    REG_JUMP("MythStream", "AV stream plugin", "", runStream);
     
    REG_KEY("Stream", "PAUSE", "Pause stream", "P");
    REG_KEY("Stream", "VOLDN", "Volume down", "[,{,F10");
    REG_KEY("Stream", "VOLUP", "Volume up", "],},F11");
    REG_KEY("Stream", "AVINC", "Delay video", "-");
    REG_KEY("Stream", "AVDEC", "Delay audio", "+");
    REG_KEY("Stream", "MUTE", "mute", "|,\\,F9");
    REG_KEY("Stream", "END", "Stop stream", "O,End");
    // SELECT when playing video also toggles fullscreen
    REG_KEY("Stream", "FULLSCREEN", "toggle fullscreen", "F,R");
    REG_KEY("Stream", "FORWARD",  "forward", ">");
    REG_KEY("Stream", "REWIND",  "rewind", "<");
    REG_KEY("Stream", "MARK",  "mark stream", "M");
    REG_KEY("Stream", "STOREMARKED",  "store marked streams", "Y,C");
    REG_KEY("Stream", "INSPECT",  "display detailed information", "I");
    REG_KEY("Stream", "DUMP",  "display player dump", "D");
    // 1..8: select configured storage
    // 9   : select /usr/[local/]share/mythtv/mythstream/streams.res storage
    // 0   : select default storage "mythstream" (mythconverg.streams table)
    // ESC : stop stream, or quit mythstream when no stream is playing
}

int mythplugin_init(const char *libversion)
{
    if (!gContext->TestPopupVersion("mythstream",
                                    libversion,
                                    MYTH_BINARY_VERSION))
        return -1;

    setupKeys();

    return 0;
}

void runStream(void)
{
    gContext->addCurrentLocation("mythstream");
    MythStream stream(gContext->GetMainWindow(), "stream");
    stream.exec();
    gContext->removeCurrentLocation( );
}

int mythplugin_run(void)
{
    runStream( );
    return 0;
}


int mythplugin_config(void)
{
    QString themedir = gContext->GetThemeDir( );
    runMenu( themedir, "streamconfigmenu.xml");
    return 0;
}



