/* ============================================================
 * File  : playerencap.cpp
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description : external player control, uses player.xml
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#ifndef PLAYERENCAP_H
#define PLAYERENCAP_H

#include <iostream>
#include <qdict.h>
#include <qmap.h>
#include <qregexp.h>
#include <qdom.h>

using namespace std;


class StreamParameter;
class StreamProperty;

class PlayerEncap
{
  public:

    typedef QDict<StreamParameter> ParseMap;
    typedef QDict<StreamProperty>  PropMap;
    typedef QMap<QString,QString>  StringMap;

    PlayerEncap();
    ~PlayerEncap();
    
    bool checkStreamPropertyConfigured(const QString& name);
    QString& getStreamProperty(const QString& name, bool clear);
    QString& getStreamPropertyArea(const QString& name);
    QString& getStreamPropertyTitle(const QString& name);
    QString& getPlayerSys(const QString& name);
    QString& getPlayerCmd(const QString& name);
    QString& getCurrentCacheUsage();

    int pushParameter(QString& label, QString& value);
    void reset();

    StringMap playerParam;     // custom player command line parameters

  private:
    ParseMap  parseMap;        // maps player stdout lines to StreamParameter
    PropMap   propMap;         // maps StreamInfo names to StreamProperty
    StringMap playerSys;       // player and known player command line parameters
    StringMap playerCmd;       // stdin player commands

    int getStatusFromStr(QString& status);
    QDomElement getFirstElement(QDomElement base, const QString& tagname);
    void fillFilterMap(QDomElement& parentNode);
    void fillMap(QMap<QString,QString>& map, QDomElement& parentNode);
    void loadPlayerRegExp();

    StreamProperty* streamCacheProperty; // StreamProperty "StreamPlayCache"

};

#endif /* PLAYERENCAP_H */


