#$Header: /opt/cvs/python/packages/share1.5/Pmv/Tests/test_loadCommands.py,v 1.2 2007/12/04 17:55:16 sargis Exp $
# Author: Sargis Dallakyan - sargis@scripps.edu
# Summary: Makes sure that all Pmv modules can be loaded.
#$Id: test_loadCommands.py,v 1.2 2007/12/04 17:55:16 sargis Exp $
import unittest, sys, os, time
from mglutil.util.packageFilePath import findModulesInPackage
import Pmv

class LoadTest(unittest.TestCase):
    """Base class for unittest"""
    def test_loadAllModules(self):
        from Pmv.moleculeViewer import MoleculeViewer
        mv = MoleculeViewer(customizer = './.empty', logMode = 'no',
                            withShell=0, trapExceptions=False)
        mv.setUserPreference(('warningMsgFormat', 'printed'), log = 0)
        PmvPath = Pmv.__path__[0]
        modules = findModulesInPackage(PmvPath,"^def initModule")[PmvPath]
        failedTest = []
        for module_py in modules:
            module = os.path.splitext(module_py)[0]
            print 'loading...' + module
            try:
                mv.loadModule(module, 'Pmv')
            except Exception, inst:
                print inst
                failedTest.append(module_py)
            
        self.assertEqual(failedTest,[])
if __name__ == '__main__':
        unittest.main()

    
