/***************************************************************************

  video.c

***************************************************************************/

#include "emu.h"
#include "video/konicdev.h"
#include "includes/qdrmfgp.h"



void qdrmfgp_tile_callback(running_machine &machine, int layer, int *code, int *color, int *flags)
{
	qdrmfgp_state *state = machine.driver_data<qdrmfgp_state>();
	*color = ((*color>>2) & 0x0f) | state->m_pal;
}

void qdrmfgp2_tile_callback(running_machine &machine, int layer, int *code, int *color, int *flags)
{
	*color = (*color>>1) & 0x7f;
}

/***************************************************************************

  Start the video hardware emulation.

***************************************************************************/

VIDEO_START_MEMBER(qdrmfgp_state,qdrmfgp)
{
	k056832_set_layer_association(m_k056832, 0);

	k056832_set_layer_offs(m_k056832, 0, 2, 0);
	k056832_set_layer_offs(m_k056832, 1, 4, 0);
	k056832_set_layer_offs(m_k056832, 2, 6, 0);
	k056832_set_layer_offs(m_k056832, 3, 8, 0);
}

VIDEO_START_MEMBER(qdrmfgp_state,qdrmfgp2)
{
	k056832_set_layer_association(m_k056832, 0);

	k056832_set_layer_offs(m_k056832, 0, 3, 1);
	k056832_set_layer_offs(m_k056832, 1, 5, 1);
	k056832_set_layer_offs(m_k056832, 2, 7, 1);
	k056832_set_layer_offs(m_k056832, 3, 9, 1);
}

/***************************************************************************

  Display refresh

***************************************************************************/

UINT32 qdrmfgp_state::screen_update_qdrmfgp(screen_device &screen, bitmap_ind16 &bitmap, const rectangle &cliprect)
{
	bitmap.fill(get_black_pen(machine()), cliprect);

	k056832_tilemap_draw(m_k056832, bitmap, cliprect, 3, 0, 1);
	k056832_tilemap_draw(m_k056832, bitmap, cliprect, 2, 0, 2);
	k056832_tilemap_draw(m_k056832, bitmap, cliprect, 1, 0, 4);
	k056832_tilemap_draw(m_k056832, bitmap, cliprect, 0, 0, 8);
	return 0;
}
