/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xalan" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, Lotus
 * Development Corporation., http://www.lotus.com.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.xalan.xpath.xml;

import java.io.*;
import java.net.URL;

import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.parsers.*;

import org.apache.xalan.xpath.xml.*;
import org.apache.xalan.xpath.*;


/**
 *  Allow use of a generic JAXP parser with Xalan.
 *  Patch from Costin Manolache 
 */
public class JaxpLiaison extends XMLParserLiaisonDefault
{
  // later.
  String domFactoryName=null;
  String saxFactoryName=null;
  
  public JaxpLiaison()
  {
  }

  // debug
  static final int debug=0;
  void d( String s) {
    System.out.println("JaxpLiaison: " + s );
  }

  // -------------------- Liason implementation --------------------

  public String getParserDescription()
  {
    return "Jaxp";
  }
  
  public void checkNode(Node node)
    throws SAXException
  {
    if( debug>0) d("Calling checkNode");
  }

  public boolean supportsSAX()
  {
    if(debug>0) d("Calling supportsSAX");
    return true;
  }

  public void parse (InputSource source)
    throws SAXException, IOException
  {
    try {
      if( m_docHandler != null ) 
      {        
        SAXParserFactory sf=null;
        //if( saxFactoryName == null)
        sf=SAXParserFactory.newInstance();
        // 		 		 else
        // 		 		     sf=SAXParserFactory.newInstance(saxFactoryName);

        //sf.setNamespaceAware( true );
        SAXParser saxP=sf.newSAXParser();
        
        Parser p=saxP.getParser();

        if( debug>0) 
          d("Parse " + m_docHandler +
                       " " + m_DTDHandler+ 
                       " " + m_errorHandler +
                       " " + m_entityResolver);
        
        p.setDocumentHandler( m_docHandler);

        if(null != m_DTDHandler) 
        {
          p.setDTDHandler(m_DTDHandler);
        }
        
        if(null != m_errorHandler) 
        {
          p.setErrorHandler(m_errorHandler);
        }  
        else 
        {
          String ident = source.getSystemId();
          if( ident==null ) ident=source.toString();
          p.setErrorHandler(new DefaultErrorHandler(ident));
        }
        
        if(null != m_entityResolver) 
        {
          p.setEntityResolver(m_entityResolver);
        }
        
        p.parse(source);
        // XXX XXX Workaround - without this stylesheed handler will
        // remain set
        m_docHandler=null;
      } 
      else 
      {
        if(debug>0) d("XalanJaxpLiaison: dom parse " + m_docHandler +
                      " " + m_entityResolver + " " + m_errorHandler);
        DocumentBuilderFactory df=null;
        // 		 		 if( domFactoryName==null )
        df=DocumentBuilderFactory.newInstance();
        // else
        // 		 		     df=DocumentBuilderFactory.newInstance(domFactoryName);
        df.setNamespaceAware( true );
        DocumentBuilder docB=df.newDocumentBuilder();
        
        if (m_entityResolver != null) 
        {
          docB.setEntityResolver(m_entityResolver);
        }
        
        if (m_errorHandler != null) 
        {
          docB.setErrorHandler(m_errorHandler);      
        }
        

        m_document= docB.parse(source);
      }
    } 
    catch(Exception e ) 
    {
      e.printStackTrace();
    }
  }

  public Document getDocument() 
  {
    if(debug>0) d( "getDocument() " + m_document);
    return m_document;
  }
  
  /**
   * Create an empty DOM Document.  Mainly used for creating an
   * output document.  Implementation of XMLParserLiaison
   * interface method.
   */
  public Document createDocument()
  {
    if(debug>0) d( "createDocument() " );
    try {
      DocumentBuilderFactory df=DocumentBuilderFactory.newInstance();
      DocumentBuilder docB=df.newDocumentBuilder();
      return docB.newDocument();
    } 
    catch( Exception ex ) 
    {
      ex.printStackTrace();
      return null;
    }
  }

  public Element getElementByID(String id, Document doc)
  {
    if(debug>-1) d("GetElemByID");
    return null; 
  }
}

