/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

/*
 * Created on Jan 16, 2006
 */
package org.jboss.test.remoting.transport.multiplex;

import java.net.InetSocketAddress;

import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.transport.multiplex.MultiplexServerInvoker;
import org.jboss.test.remoting.transport.multiplex.utility.SuccessCountingTestCase;


/**
 * A MultiplexInvokerTimeoutTestCase.
 
 * @author <a href="mailto:r.sigal@computer.org">Ron Sigal</a>
 * @version $Revision: 1.4 $
 * <p>
 * Copyright (c) 2005
 * </p>
 */

public class MultiplexInvokerTimeoutTestCase extends SuccessCountingTestCase
{
   protected static final Logger log = Logger.getLogger(BasicSocketBehaviorClient.class);
   
   public void testTimeout()
   {
      try
      {
         // Create Connector.
         int serverPort = PortUtil.findFreePort("localhost");
         String connectorURI = "multiplex://localhost:" + serverPort + "/?timeout=2000";
         InvokerLocator connectorLocator = new InvokerLocator(connectorURI);
         System.out.println("Starting remoting server with locator uri of: " + connectorURI);
         log.info("Starting remoting server with locator uri of: " + connectorURI);
         Connector connector = new Connector();
         connector.setInvokerLocator(connectorLocator.getLocatorURI());
         connector.create();
         connector.start();
         
         // Create Client.
         int clientPort = PortUtil.findFreePort("localhost");
         String clientURI = connectorURI + "&multiplexBindHost=localhost&multiplexBindPort=" + clientPort;
         InvokerLocator clientLocator = new InvokerLocator(clientURI);
         Client client = new Client(clientLocator);
         client.connect();
         
         // Give virtual MultiplexServerInvoker time to start.
         Thread.sleep(1000);
         
         // Get master MultiplexServerInvoker
         MultiplexServerInvoker masterInvoker = null;
         ServerInvoker[] serverInvokers = InvokerRegistry.getServerInvokers();;
         for (int i = 0; i < serverInvokers.length; i++)
         {
            if(serverInvokers[i].getLocator().equals(connectorLocator))
            {
               if(serverInvokers[i] instanceof MultiplexServerInvoker)
               {
                  masterInvoker = (MultiplexServerInvoker) serverInvokers[i];
//                  break;
               }
            }
         }
         
         assertTrue(masterInvoker != null);
         
         // Get virtual MultiplexServerInvoker
         InetSocketAddress bindAddress = new InetSocketAddress("localhost", clientPort);
         MultiplexServerInvoker virtualInvoker = masterInvoker.getServerInvoker(bindAddress);
         log.info(masterInvoker.getLocator());
         System.out.println(masterInvoker.getLocator());
         System.out.println(masterInvoker.getServerInvokers().size());
         log.info("server invokers: " + masterInvoker.getServerInvokers().size());
         assertTrue(virtualInvoker != null);
         
         // Give virtual MultiplexServerInvoker time to time out, then check that it's still running.
         Thread.sleep(5000);
         virtualInvoker = masterInvoker.getServerInvoker(bindAddress);
         assertTrue(virtualInvoker != null);
         
         // Shut down Client.
         client.disconnect();

         // Give virtual MultiplexServerInvoker time to time out, then check that it shut down.
         Thread.sleep(5000);
         virtualInvoker = masterInvoker.getServerInvoker(bindAddress);
         assertTrue(virtualInvoker == null);
         
         connector.stop();
      }
      catch (Exception e)
      {
         log.error(e);
         e.printStackTrace();
         fail();
      }
      
      log.info("testTimeout() PASSES");
      OKCounter++;
   }
}

