/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.util;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.KeyStroke;
import org.workingfrog.i18n.util.Loader;
import org.workingfrog.i18n.util.ResourceBundleFilter;

public class Localizer {
    private static Loader loader = new Loader();

    public static void switchCurrentLocale(Locale locale) {
        Locale.setDefault(locale);
        loader.reload();
    }

    public static Locale getCurrentLocale() {
        return Locale.getDefault();
    }

    public static Map getResourcesFor(Locale locale) {
        return loader.getBundles(locale);
    }

    public static synchronized void addResource(String binding, String resourceName) throws MissingResourceException {
        loader.loadResource(binding, resourceName);
    }

    public static String localize(String binding, String key) {
        ResourceBundle bundle = loader.getBundle(binding);
        Object object = Localizer.getValue(bundle, key);
        return object == null ? key : (String)object;
    }

    private static Object getValue(ResourceBundle bundle, String key) {
        try {
            if (bundle instanceof ListResourceBundle) {
                return ((ListResourceBundle)bundle).handleGetObject(key);
            }
            return ((PropertyResourceBundle)bundle).handleGetObject(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static boolean containsKey(String binding, String key) {
        ResourceBundle bundle = loader.getBundle(binding);
        if (bundle == null) {
            return false;
        }
        return Localizer.getValue(bundle, key) != null;
    }

    public static KeyStroke getShortcut(String binding, String key) {
        KeyStroke stroke = null;
        ResourceBundle resource = loader.getBundle(binding);
        try {
            Object obj = resource.getObject(key);
            if (obj instanceof KeyStroke) {
                stroke = (KeyStroke)obj;
            } else if (obj instanceof String) {
                boolean hasShortcutModifier = false;
                StringBuffer shortcutBuf = new StringBuffer();
                StringTokenizer tokenizer = new StringTokenizer((String)obj);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.equals("shortcut")) {
                        hasShortcutModifier = true;
                        continue;
                    }
                    shortcutBuf.append(token);
                    shortcutBuf.append(" ");
                }
                stroke = KeyStroke.getKeyStroke(shortcutBuf.toString());
                int modifiers = stroke.getModifiers() | (hasShortcutModifier ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() : 0);
                int keyCode = stroke.getKeyCode();
                stroke = KeyStroke.getKeyStroke(keyCode, modifiers);
            }
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return stroke;
    }

    public static Locale[] getLocales(Object object) {
        String[] names = null;
        HashSet<String> set = new HashSet<String>();
        names = object.getClass().getResource(".") == null ? Localizer.getListingFromJar(object) : Localizer.getListingFromDir(object);
        int i = 0;
        while (i < names.length) {
            names[i] = names[i].substring(names[i].indexOf("ResourceBundle") + 14);
            names[i] = names[i].substring(0, names[i].lastIndexOf("."));
            if (!names[i].equals("")) {
                set.add(names[i].substring(1));
            }
            ++i;
        }
        Locale[] locales = new Locale[set.size()];
        int index = 0;
        Iterator i2 = set.iterator();
        while (i2.hasNext()) {
            StringTokenizer tokens = new StringTokenizer((String)i2.next(), "_");
            switch (tokens.countTokens()) {
                case 1: {
                    locales[index++] = new Locale(tokens.nextToken(), "");
                    break;
                }
                case 2: {
                    locales[index++] = new Locale(tokens.nextToken(), tokens.nextToken());
                    break;
                }
                case 3: {
                    locales[index++] = new Locale(tokens.nextToken(), tokens.nextToken(), tokens.nextToken());
                }
            }
        }
        return locales;
    }

    private static String[] getListingFromJar(Object object) {
        URL url = object.getClass().getResource(".");
        JarURLConnection uc = null;
        Enumeration<JarEntry> enumeration = null;
        String classFile = "/" + object.getClass().getName().replace('.', '/') + ".class";
        String extForm = object.getClass().getResource(classFile).toExternalForm();
        String root = extForm.substring(0, extForm.length() - classFile.length());
        if (root.startsWith("jar:") && (root = root.substring(4)).endsWith("!")) {
            root = root.substring(0, root.length() - 1);
        }
        try {
            url = new URL("jar", "", String.valueOf(root) + "!/");
            uc = (JarURLConnection)url.openConnection();
            JarFile dir = uc.getJarFile();
            enumeration = dir.entries();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Vector<String> v = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String file = ((JarEntry)enumeration.nextElement()).getName();
            if ((file.indexOf("i18n") <= -1 || file.indexOf("ResourceBundle.") <= -1) && file.indexOf("ResourceBundle_") <= -1) continue;
            v.addElement(file.substring(file.lastIndexOf("/") + 1));
        }
        v.trimToSize();
        Object[] array = v.toArray();
        String[] names = new String[array.length];
        int i = 0;
        while (i < array.length) {
            names[i] = (String)array[i];
            ++i;
        }
        return names;
    }

    private static String[] getListingFromDir(Object object) {
        URL url = object.getClass().getResource(".");
        File dir = new File(url.getFile());
        return dir.list(ResourceBundleFilter.getInstance());
    }
}

