/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Translator;

public class I18NAction
extends AbstractAction
implements LocaleListener {
    private String bundle = "action";
    public static final String ACTION = "action";
    private String i18nKey = "action.error";

    public I18NAction() {
    }

    public I18NAction(String i18nKey) {
        this(ACTION, i18nKey);
    }

    public I18NAction(String bundle, String i18nKey) {
        super(i18nKey);
        this.bundle = bundle;
        this.putValue("Name", Translator.checkValue(bundle, i18nKey, this));
        Translator.localize(i18nKey, this);
        Translator.checkKey(i18nKey, this);
        this.i18nKey = i18nKey;
    }

    public I18NAction(String bundle, String i18nKey, Icon icon) {
        this(bundle, i18nKey);
        this.putValue("SmallIcon", icon);
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getKey() {
        return this.i18nKey;
    }

    public void actionPerformed(ActionEvent event) {
    }

    public void localeChanged(LocaleEvent event) {
        this.putValue("Name", Translator.checkValue(this.bundle, this.i18nKey, this));
    }
}

