/* UnknownInvariantException.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants;

/**
 * Indicates that the id of an unknown invariant or invariant factory was 
 * encountered.
 */
public class UnknownInvariantException extends Exception {
    
    //
    private String id;
    
    /**
     * The identifier of the invariant which was unknown.
     */
    public String getId () {
        return this.id;
    }
    /**
     * Construct an exception of this type
     * @param message Error message
     * @param id Invariant for which this exception was thrown
     * @param cause Underlying cause
     */
    public UnknownInvariantException (String message, String id, Throwable cause) {
        super (message, cause);
        this.id = id;
    }

    /**
     * Construct an exception of this type
     * @param message Error message
     * @param id Invariant for which this exception was thrown
     */
    public UnknownInvariantException (String message, String id) {
        super (message);
        this.id = id;
    }
}
