/* PrioritizedRunnableExecutor.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants;

import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * The global PrioritizedRunnableExecutor. It handles the pool of threads that
 * execute {@link PrioritizedRunnable}s.
 */
public class PrioritizedRunnableExecutor {
    
    //
    private static final PrioritizedRunnableExecutor INSTANCE = new PrioritizedRunnableExecutor();
    
    public static PrioritizedRunnableExecutor getInstance() {
        return INSTANCE;
    }
    
    //
    private int counter = 0;
    
    public int getCount() {
        return counter++;
    }
    
    //
    //private ExecutorService tpes_background = Executors.newFixedThreadPool(1);
    
    //
    private Executor tpes_current = 
            new ThreadPoolExecutor(
                2,
                2,
                0L,
                TimeUnit.MILLISECONDS,
                new PriorityBlockingQueue<Runnable>(),
                new DefaultThreadFactory());
    
    private PrioritizedRunnableExecutor() { }
    
    /**
     * Execute the given runnable
     * @param command Runnable to execute
     */
    public void execute(PrioritizedRunnable command) {
        /*
        if (command.getPriority() == 0)
            tpes_background.execute(command);
        else
         */
        tpes_current.execute(command);
    }
    
    private static class DefaultThreadFactory implements ThreadFactory {
        final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        
        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            group = (s != null)? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }
        
        public Thread newThread(Runnable r) {
            Thread t = new Thread(
                    group,
                    r,
                    namePrefix + threadNumber.getAndIncrement(),
                    0);
            if (t.isDaemon())
                t.setDaemon(false);
            t.setPriority(Thread.MIN_PRIORITY);
            return t;
        }
    }
}
