/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "fame.h"

FAME_ALIGNED static const fame_vlc_t mcbpc_I[4] = {
  { 1, 1 },
  { 1, 3 },
  { 2, 3 },
  { 3, 3 },
};

FAME_ALIGNED static const fame_vlc_t mcbpc_I_dq[4] = {
  { 1, 4 },
  { 1, 6 },
  { 2, 6 },
  { 3, 6 }
};

FAME_ALIGNED static const fame_vlc_t mcbpc_P_intra[4] = {
  { 3, 5 },
  { 4, 8 },
  { 3, 8 },
  { 3, 7 }
};

FAME_ALIGNED static const fame_vlc_t mcbpc_P_intra_dq[4] = {
  { 4, 6 },
  { 4, 9 },
  { 3, 9 },
  { 2, 9 }
};

FAME_ALIGNED static const fame_vlc_t mcbpc_P_inter[4] = {
  { 1, 1 },
  { 3, 4 },
  { 2, 4 },
  { 5, 6 }
};

FAME_ALIGNED static const fame_vlc_t mcbpc_P_inter_dq[4] = {
  { 0, 12 },
  { 1, 12 },
  { 2, 12 },
  { 3, 12 }
};

FAME_ALIGNED static const fame_vlc_t mcbpc_P_inter4v[4] = {
  { 2, 3 },
  { 5, 7 },
  { 4, 7 },
  { 5, 8 }
};

FAME_ALIGNED static const fame_vlc_t cbpy_four[16] = {
  { 0x03, 4 },
  { 0x05, 5 },
  { 0x04, 5 },
  { 0x09, 4 },
  { 0x03, 5 },
  { 0x07, 4 },
  { 0x02, 6 },
  { 0x0b, 4 },
  { 0x02, 5 },
  { 0x03, 6 },
  { 0x05, 4 },
  { 0x0a, 4 },
  { 0x04, 4 },
  { 0x08, 4 },
  { 0x06, 4 },
  { 0x03, 2 }
};

FAME_ALIGNED static const fame_vlc_t cbpy_three[8] = {
  { 0x03, 3 },
  { 0x01, 6 },
  { 0x01, 5 },
  { 0x02, 3 },
  { 0x02, 5 },
  { 0x03, 5 },
  { 0x01, 3 },
  { 0x01, 1 }
};

FAME_ALIGNED static const fame_vlc_t cbpy_two[4] = {
  { 0x01, 4 },
  { 0x01, 3 },
  { 0x01, 2 },
  { 0x01, 1 }
};

FAME_ALIGNED static const fame_vlc_t cbpy_one[2] = {
  { 0x01, 2 },
  { 0x01, 1 },
};

FAME_ALIGNED static const fame_vlc_t *cbpy[4] = {
  cbpy_one,
  cbpy_two,
  cbpy_three,
  cbpy_four
};
