/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

public class EventTrace {
    private static int MAX_EVENTS = 100;
    public static final boolean TRACE_EVENTS = false;
    static int currentEvent = 0;
    static final EventTrace[] events = new EventTrace[MAX_EVENTS];
    static final int[] threadIdHashes = new int[MAX_EVENTS];
    static boolean disableEvents = false;
    protected String comment;

    public EventTrace(String comment) {
        this.comment = comment;
    }

    public EventTrace() {
        this.comment = null;
    }

    public String toString() {
        return this.comment;
    }

    public static void addEvent(EventTrace event) {
        if (disableEvents) {
            return;
        }
        int nextEventIdx = currentEvent++ % MAX_EVENTS;
        EventTrace.events[nextEventIdx] = event;
        EventTrace.threadIdHashes[nextEventIdx] = System.identityHashCode(Thread.currentThread());
    }

    public static void addEvent(String comment) {
        if (disableEvents) {
            return;
        }
        EventTrace.addEvent(new EventTrace(comment));
    }

    public static void dumpEvents() {
        if (disableEvents) {
            return;
        }
        System.out.println("----- Event Dump -----");
        EventTrace[] oldEvents = events;
        int[] oldThreadIdHashes = threadIdHashes;
        disableEvents = true;
        int j = 0;
        int i = currentEvent;
        while (j < MAX_EVENTS) {
            EventTrace ev = oldEvents[i % MAX_EVENTS];
            if (ev != null) {
                int thisEventIdx = i % MAX_EVENTS;
                System.out.print(oldThreadIdHashes[thisEventIdx] + " ");
                System.out.println(j + "(" + thisEventIdx + "): " + ev);
            }
            ++j;
            ++i;
        }
    }
}

