/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.io.File;

public class CmdUtil {
    private static final String printableChars = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

    public static String getArg(String[] argv, int whichArg) throws IllegalArgumentException {
        if (whichArg < argv.length) {
            return argv[whichArg];
        }
        throw new IllegalArgumentException();
    }

    public static long readLongNumber(String longVal) {
        if (longVal.startsWith("0x")) {
            return Long.parseLong(longVal.substring(2), 16);
        }
        return Long.parseLong(longVal);
    }

    public static void formatEntry(StringBuffer sb, byte[] entryData, boolean formatUsingPrintable) {
        for (int i = 0; i < entryData.length; ++i) {
            String hex;
            int b = entryData[i] & 0xFF;
            if (formatUsingPrintable) {
                if (CmdUtil.isPrint(b)) {
                    if (b == 92) {
                        sb.append('\\');
                    }
                    sb.append(printableChars.charAt(b - 33));
                    continue;
                }
                sb.append('\\');
                hex = Integer.toHexString(b);
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(hex);
                continue;
            }
            hex = Integer.toHexString(b);
            if (b < 16) {
                sb.append('0');
            }
            sb.append(hex);
        }
    }

    private static boolean isPrint(int b) {
        return b < 127 && 32 < b;
    }

    public static EnvironmentImpl makeUtilityEnvironment(File envHome, boolean readOnly) throws DatabaseException {
        EnvironmentConfig config = new EnvironmentConfig();
        config.setReadOnly(readOnly);
        config.setConfigParam(EnvironmentParams.JE_LOGGING_DBLOG.getName(), "false");
        config.setConfigParam(EnvironmentParams.JE_LOGGING_CONSOLE.getName(), "true");
        config.setConfigParam(EnvironmentParams.JE_LOGGING_LEVEL.getName(), "SEVERE");
        config.setConfigParam(EnvironmentParams.ENV_RECOVERY.getName(), "false");
        EnvironmentImpl envImpl = new EnvironmentImpl(envHome, config);
        return envImpl;
    }
}

