/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KXMAME_JOY_H_
#define _KXMAME_JOY_H_

#include <qsocketnotifier.h>
#include <qtimer.h>

extern "C" {
#include <glib.h>
}

typedef struct {
	char *device_name;
	int num_axis;
	int *axis;
	int num_buttons;
	int *buttons;
	GIOChannel *io_channel;
	guint source_id;
} Joystick;

class joyNotifier : public QSocketNotifier
{
	Q_OBJECT
	public:
		joyNotifier( int socket, QSocketNotifier::Type type, QObject * parent = 0, const char * name = 0 );
		~joyNotifier();
	
		int mFd, joyAxisDir;
		QTimer *mTimer;
	
	public slots:
		void joystick_io_func(int);
		void joyAxisRepeat();
};

#define JOYSELECT	0
#define JOYPANELSWITCH	1
#define JOYEXECSWITCH	2
#define JOYPARENT	3
#define JOYALT		4
#define JOYTOTAL	5

void setupJoyEventReceivers();
Joystick *joystick_new (char * joystick);
void joystick_close (Joystick *joydata);
void joy_focus_on (void);
void joy_focus_off (void);
const char *get_joy_dev (void);


#endif
