/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>

#include <qpixmap.h>
#include <qimage.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpen.h>
#include <qsize.h>
#include <qpoint.h>
#include <qfont.h>
#include <ksplashscreen.h>

#include "kxmameSplash.h"
#include "kxmamelogo.h"

#define splashBandHeight	35
#define borderWidth		1

kxmameSplashScreen::kxmameSplashScreen(const QPixmap &pixmap)
	: KSplashScreen(pixmap)
{
	int w = pixmap.width();
	int h = pixmap.height();
	
	float scale = (float)(w-2*splashBandHeight)/w;
	h = int(h*scale);
	
	QPixmap actualPix = QPixmap(w, h+2*splashBandHeight);
	
	QImage img = QImage( kxmameLogo().convertToImage() );
	QPixmap pic = QPixmap();
	pic.convertFromImage( img.smoothScale( int(w*scale), h, QImage::ScaleMin ) );
	QPainter painter(&actualPix);
	painter.fillRect(actualPix.rect(), QColor(255,255,255));
	painter.drawPixmap(splashBandHeight,splashBandHeight*15/12,pic);
	
	painter.setPen(QColor(82,174,223));
	QFont bigFont = painter.font();
	bigFont.setBold(TRUE);
	bigFont.setPointSize(13);
	bigFont.setStretch(80);
	bigFont.setFamily("Arial");
	painter.setFont(bigFont);
	painter.drawText(QRect(0, 0, width(), splashBandHeight*22/12),
			  Qt::AlignHCenter | Qt::AlignVCenter, 
			  i18n("KDE FRONTEND FOR XMAME/XMESS"));
	
	painter.setPen(QPen(QColor(0,0,0), borderWidth));
	painter.drawRect(actualPix.rect());
	
	setPixmap(actualPix);
}

void kxmameSplashScreen::setMessage(const QString &str)
{
	currStatus = str;
	message(str);
}

void kxmameSplashScreen::drawContents(QPainter *painter)
{
	painter->setPen(QColor(0,0,100));
	painter->drawText( QRect(0,height()-splashBandHeight, width(), splashBandHeight)
			, Qt::AlignHCenter | Qt::AlignVCenter, currStatus );
}

#include "kxmameSplash.moc"
