/*********************************************************************
 *
 *      Copyright (C) 2002 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * PROJECT:     JSwat
 * MODULE:      Unit Tests
 * FILE:        threadbrkTest.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      08/09/02        Initial version
 *
 * $Id: threadbrkTest.java 662 2002-11-02 07:25:59Z nfiedler $
 *
 ********************************************************************/

package com.bluemarsh.jswat.command;

import com.bluemarsh.jswat.Session;
import com.bluemarsh.jswat.SessionManager;
import com.bluemarsh.jswat.SessionSetup;
import junit.extensions.*;
import junit.framework.*;

/**
 * Tests the threadbrk command.
 */
public class threadbrkTest extends CommandTestCase {

    public threadbrkTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SessionSetup(new TestSuite(threadbrkTest.class));
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public void test_threadbrk() {
        Session session = SessionManager.beginSession();

        runCommand(session, "threadbrk");
        runCommand(session, "threadbrk go");
        runCommand(session, "threadbrk thread");
        runCommand(session, "threadbrk start");
        runCommand(session, "threadbrk death");
        // yep, it will accept all of them, but last one wins
        runCommand(session, "threadbrk go thread start death");
        runCommand(session, "clear all");
        SessionManager.endSession();
    }
}
