/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.AssociationBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BPCCBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ChannelDefBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ColorSpecBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComponentMapBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ImageHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.LabelBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.PaletteBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ROIBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ResolutionBox;
import java.io.IOException;
import java.io.RandomAccessFile;

public class JP2HeaderBox
extends JP2Box {
    public JP2HeaderBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        Property property;
        this.initBytesRead();
        this.hasBoxes = true;
        if (this._module.isJP2HdrSeen()) {
            this._repInfo.setMessage((Message)new ErrorMessage("Multiple JP2 Header Boxes not allowed", this._module.getFilePos()));
            this._repInfo.setValid(false);
            if (this._boxHeader.getLength() != 0L) {
                this._module.skipBytes(this._dstrm, (int)this._boxHeader.getDataLength(), this._module);
            }
        }
        this._module.setJP2HdrSeen(true);
        if (this._module.getNCodestreams() > 0) {
            this._module.setJP2Compliant(false);
        }
        int n = 0;
        JP2Box jP2Box = null;
        boolean bl = false;
        boolean bl2 = false;
        while (this.hasNext()) {
            jP2Box = (JP2Box)this.next();
            if (n == 0 && jP2Box instanceof LabelBox) {
                n = 1;
                this._module.setJP2Compliant(false);
                if (!jP2Box.readBox()) {
                    return false;
                }
                this._module.addProperty(new Property("JP2HeaderLabel", PropertyType.STRING, (Object)((LabelBox)jP2Box).getLabel()));
                jP2Box = (JP2Box)this.next();
                continue;
            }
            if (n <= 1) {
                if (jP2Box instanceof ImageHeaderBox) {
                    n = 2;
                    if (jP2Box.readBox()) continue;
                    return false;
                }
                this._repInfo.setMessage((Message)new ErrorMessage("First box of JP2 header must be image header", this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
            if (jP2Box instanceof AssociationBox || jP2Box instanceof BPCCBox || jP2Box instanceof ColorSpecBox || jP2Box instanceof PaletteBox || jP2Box instanceof ComponentMapBox || jP2Box instanceof ChannelDefBox || jP2Box instanceof ResolutionBox || jP2Box instanceof ROIBox) {
                if (jP2Box.readBox()) continue;
                return false;
            }
            jP2Box.skipBox();
        }
        if (bl && !bl2) {
            this._repInfo.setMessage((Message)new ErrorMessage("JP2 Header has Component Mapping box without Palette Box", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        if (!bl && bl2) {
            this._repInfo.setMessage((Message)new ErrorMessage("JP2 Header has Palette box without Component Mapping Box", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        if ((property = this.makeAssocProperty()) != null) {
            this._module.addProperty(property);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "JP2 Header Box";
    }
}

