package jfractionlab.worksheets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import javax.swing.JOptionPane;

import jfractionlab.GreatestCommonDivisor;
import jfractionlab.JFractionLab;
import jfractionlab.jflDialogs.InfoDialog;

abstract class WorkSheetGenerator {

	protected String strhead="";
	protected ArrayList<String> al_exercisesText;
	protected ArrayList<String> al_solutionsText;
	protected ArrayList<String> al_solutionLine;
	protected int nb_of_exercises;
	protected int nb_of_columns;
	
	public static int ONE_COLUMN = 1;
	public static int TWO_COLUMN = 2;
	
	public int n1,d1,n2,d2;
	
	public WorkSheetGenerator(String title, int nb_of_columns) throws IllegalArgumentException{
		
		if(!(nb_of_columns == 1 || nb_of_columns == 2)){
			throw new IllegalArgumentException("wrong argument");
		}else{
			this.nb_of_columns = nb_of_columns;
			
			if(nb_of_columns == 1){
				nb_of_exercises = 15; 
			}else if(nb_of_columns == 2){
				nb_of_exercises = 30;
			}	
				
			al_exercisesText = new ArrayList<String>();
			al_solutionsText = new ArrayList<String>();	
			
			strhead =
//				"\\documentclass[12pt,ngerman]{scrartcl}\n"+
				"\\documentclass[12pt]{scrartcl}\n"+
				"\\usepackage[T1]{fontenc}\n"+
				"\\usepackage{ucs}\n"+
				"\\usepackage[utf8x]{inputenc}\n"+
//				"\\usepackage{ngerman}\n"+
//				"\\usepackage[ngerman]{babel}\n"+
				"\\usepackage{cancel}\n"+
				"\\setlength{\\parindent}{0pt}\n"+
				"\\pagestyle{empty}\n"+
				"\n"+
				"\\begin{document}\n"+
				"\n"+
				"\\begin{tabular}{p{7.4cm} p{7.4cm}}\n"+
				"\\underline{\\textbf{"+title+"}} \\\\[10pt]\n"+
				""+lang.Messages.getString("name")+" & "+lang.Messages.getString("date")+"\\\\[3pt]\n"+
				"\\end{tabular}\n"+
				"\n"+
				"\\renewcommand{\\arraystretch}{2.5}\n";
				
			if(nb_of_columns == 1){
				strhead += "\\begin{tabular}{|r|p{14.4cm}|}\n"; 
			}else if(nb_of_columns == 2){
				strhead += "\\begin{tabular}{|r|p{7cm}|r|p{7cm}|}\n";
			}
			strhead += "\\hline\n";
		}
	}

	abstract protected String writeOneLine(boolean isExercise, int nb);

	protected void generateText() {
	writeTxTLists("both",strhead);
	//----------------------------
	for (int i = 0; i < nb_of_exercises; i++){
		writeTxTLists("exercise", writeOneLine(true, i));
		writeTxTLists("solution", writeOneLine(false, i));
		writeTxTLists("both", "\\hline");
		if(nb_of_columns == 2) i++;
		
	}//for
	//----------------------------
	writeTxTLists("both","\\end{tabular}");
	//----------------------------
	writeTxTLists("both", "\\begin{center}");
	writeTxTLists("both", "\\begin{tiny}");
	writeTxTLists("exercise", writeSolutionLine(al_solutionLine));
	writeTxTLists("both", "\\textbf{http://sourceforge.net/projects/jfractionlab/}");
	writeTxTLists("both", "\\end{tiny}");
	writeTxTLists("both", "\\end{center}");
	//----------------------------
	writeTxTLists("both", "\\end{document}");
}
	
	protected String writeSolutionLine(ArrayList<String> al) {
		String strReturn = "";
		int r;
		int i = 0;
		String linePitch = "[3pt]";
		do{
			r = JFractionLab.ran.nextInt(al.size());
			strReturn += al.get(r);
			i++;
			if(i==(nb_of_exercises/2)){
				if(nb_of_columns == 2){
					strReturn += "\\\\"+linePitch+"\n";
				}else{
					strReturn += ", ";
				}
			}else if(i == nb_of_exercises){
				strReturn += "\\\\"+linePitch+"\n";
				i = 0;
			}else{
				strReturn += ", ";
			}
			al.remove(r);
		}while(al.size()> 0);
		return strReturn;
	}
	
	protected void writeTxTLists(String target, String txt){
		if(target.equals("both")){
			al_exercisesText.add(txt);
			al_solutionsText.add(txt);
		}else if(target.equals("exercise")){
			al_exercisesText.add(txt);
		}else if(target.equals("solution")){
			al_solutionsText.add(txt);
		}else{
			throw new IllegalArgumentException("wrong argument");
		}
	}
	
	protected void writeFile(File fl, ArrayList<String> al, boolean showInfoDialog){
		try {
			BufferedWriter bw = new BufferedWriter(
				new OutputStreamWriter(
					new FileOutputStream(fl),
					"UTF-8"
				)//OutputStreamWriter
			);//BufferedWriter
			for (int i = 0; i < al.size(); i++){
				bw.write(al.get(i));
				bw.newLine();
			}
			bw.close();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			if(showInfoDialog){
				new InfoDialog(lang.Messages.getString("title_pdfproblem"),
					"WorkSheetGenerator"+"<br>"+
					"UnsupportedEncodingException"
				);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			if(showInfoDialog){
				new InfoDialog(lang.Messages.getString("title_pdfproblem"),
						"WorkSheetGenerator"+
						"<br><br>"+
						lang.Messages.getString("files_can_not_be_saved")+
						"<br>"+
						lang.Messages.getString("file_not_found_exception")+
						"<br>"+
						lang.Messages.getString("correct_the_filename")
				);
			}
		} catch (IOException e) {
			e.printStackTrace();
			if(showInfoDialog){
				new InfoDialog(lang.Messages.getString("title_pdfproblem"),
								"WorkSheetGenerator"+"<br>"+
								"IOException"
				);
			}
		}
		String path = "";
		boolean isOK = false;
		try {
			String strpath = "";
			strpath = fl.getCanonicalPath();
			int uu = strpath.lastIndexOf(fl.getName());
			path = strpath.substring(0, uu);
			isOK = true;
		} catch (IOException e) {
			e.printStackTrace();
			new InfoDialog(lang.Messages.getString("title_pdfproblem"),
					lang.Messages.getString(
							"WorkSheetGenerator"+"<br>"+
							"IOException, getCanonicalPath"
					)
			);
		}
		
		if(isOK){
			if(JFractionLab.os.contains("linux")){
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				try {
					Runtime.getRuntime().exec("pdflatex -output-directory "+path+" "+fl.toString());
				} catch (Exception e) {
					if(showInfoDialog) installPdfLatexInfo("lin");
					isOK = false;
				}
			}else if(JFractionLab.os.contains("win")){
//				if(!new File(new ConfManager().getWinPathToPDFLATEX()).exists()){
//					installPdfLatexInfo();
//					isOK = false;
//				}else{
//					try {
//						String[] str_ar_command = { 
//								new ConfManager().getWinPathToPDFLATEX().replaceAll("\\\\", "\\\\\\\\"),
//								"-output-directory",
//								path,
//								"-interaction=batchmode",
//								fl.toString()
//						};
//						Runtime.getRuntime().exec(str_ar_command);
//					} catch (IOException e) {
//						JOptionPane.showMessageDialog(null, "miktex ist zwar installiert, klappt aber nicht");
//						isOK = false;
//					}
//				}
				isOK = false;
				if(showInfoDialog) installPdfLatexInfo("win");
			}else if(jfractionlab.JFractionLab.os.contains("mac")){
				isOK = false;
				if(showInfoDialog) installPdfLatexInfo("mac");
			}else {
				isOK = false;
			}
			if(isOK){
				int lio = fl.toString().lastIndexOf("tex");
				String flBody = fl.toString().substring(0, lio);
				File ffll = new File(flBody+"log");
				deleteFile(ffll);
				ffll = new File(flBody+"aux");
				deleteFile(ffll);
			}
		}//if (isOK)
	}//writeFile
	
	private void installPdfLatexInfo(String osys){
		if (osys.equals("lin") || osys.equals("win") || osys.equals("mac")){
			String infotxt="";
			infotxt += lang.Messages.getString("no_tex_program")+"<br>";
			infotxt += lang.Messages.getString("what_is_tex")+"<br>";
			infotxt += lang.Messages.getString("jfl_and_tex")+"<br>";
			infotxt += lang.Messages.getString("worksheets_only_in_tex")+"<br>";
			infotxt += "<br>";
			if(osys.equals("lin")){
				infotxt += lang.Messages.getString("install_pdflatex")+"<br>";
				infotxt +="<br>";
				infotxt += lang.Messages.getString("pdflatex_manually")+"<br>";
				infotxt += lang.Messages.getString("pdflatex_manually_linux");
			}else if(osys.equals("win")){
				infotxt += lang.Messages.getString("install_miktex")+"<br>";
				infotxt += "http://miktex.org/<br>";
				infotxt +="<br>";
				infotxt += lang.Messages.getString("pdflatex_manually")+"<br>";
				infotxt += lang.Messages.getString("pdflatex_manually_windows");
			}else if(osys.equals("mac")){
				infotxt += lang.Messages.getString("install_texshop")+"<br>";
				infotxt += "http://pages.uoregon.edu/koch/texshop/<br>";
				infotxt +="<br>";
				infotxt += lang.Messages.getString("pdflatex_manually")+"<br>";
				infotxt += lang.Messages.getString("pdflatex_manually_windows");
			}else{
				infotxt += lang.Messages.getString("pdflatex_manually");
			}
			new InfoDialog(lang.Messages.getString("title_pdfproblem"),infotxt,700,400);
		}else{
			System.out.println("falscher parameter");
			JOptionPane.showMessageDialog(null, "nicht linux, win oder mac");
		}
	}//installPdfLatexInfo(String os)
	
	private void deleteFile(File fl){
		int i = 0;
		do{
			try {
				Thread.sleep(200);
				i++;
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}while(!fl.exists() && i<50);
		
		if(fl.exists()){
			fl.delete();
		}else{
			System.out.println("failed to delete the files *aux or *log");
		}
	}
	public String writeReduction(){
		String strReturn="";
		
		int fn1 = 1;
		int fd1 = 1;
		int fn2 = 1;
		int fd2 = 1;
		
		boolean n1IsReduced = false;
		boolean d1IsReduced = false;
		boolean n2IsReduced = false;
		boolean d2IsReduced = false;
		
		//sort the GreatestCommonDivisors
		ArrayList<GreatestCommonDivisor> al_gcd = new ArrayList<GreatestCommonDivisor>();
		al_gcd.add(new GreatestCommonDivisor("n1d1",
				JFractionLab.greatestCommonDivisor(n1, d1)));
		al_gcd.add(new GreatestCommonDivisor("n1d2",
				JFractionLab.greatestCommonDivisor(n1, d2)));
		al_gcd.add(new GreatestCommonDivisor("n2d1",
				JFractionLab.greatestCommonDivisor(n2, d1)));
		al_gcd.add(new GreatestCommonDivisor("n2d2",
				JFractionLab.greatestCommonDivisor(n2, d2)));
		Comparator<GreatestCommonDivisor> reverse = Collections.reverseOrder();
		Collections.sort(al_gcd, reverse);

		//reduce: start with the biggest GCD
		for (int i = 0; i< al_gcd.size(); i++){
			String nameOfGCD = al_gcd.get(i).getName();
			if(nameOfGCD.equals("n1d1")){
				if(!n1IsReduced && !d1IsReduced){
					n1 = n1/al_gcd.get(i).getGcd();
					fn1 = al_gcd.get(i).getGcd();
					n1IsReduced = true;
					
					d1 = d1/al_gcd.get(i).getGcd();
					fd1 = al_gcd.get(i).getGcd();
					d1IsReduced = true;
				}
			}else if(nameOfGCD.equals("n1d2")){
				if(!n1IsReduced && !d2IsReduced){
					n1 = n1/al_gcd.get(i).getGcd();
					fn1 = al_gcd.get(i).getGcd();
					n1IsReduced = true;
					
					d2 = d2/al_gcd.get(i).getGcd();
					fd2 = al_gcd.get(i).getGcd();
					d2IsReduced = true;
				}
			}else if(nameOfGCD.equals("n2d1")){
				if(!n2IsReduced && !d1IsReduced){
					n2 = n2/al_gcd.get(i).getGcd();
					fn2 = al_gcd.get(i).getGcd();
					n2IsReduced = true;
					
					d1 = d1/al_gcd.get(i).getGcd();
					fd1 = al_gcd.get(i).getGcd();
					d1IsReduced = true;
				}
			}else if(nameOfGCD.equals("n2d2")){
				if(!n2IsReduced && !d2IsReduced){
					n2 = n2/al_gcd.get(i).getGcd();
					fn2 = al_gcd.get(i).getGcd();
					n2IsReduced = true;
					
					d2 = d2/al_gcd.get(i).getGcd();
					fd2 = al_gcd.get(i).getGcd();
					d2IsReduced = true;
				}
			}
		}
//		System.out.println("n1*fn1 / d1*fd1 * n2*fd2 / d2*fd2 = "
//				+n1+"*"+fn1+" / "+d1+"*"+fd1
//				+" * "
//				+n2+"*"+fn2+" / "+d2+"*"+fd2);
		if(fn1 == 1 && fd1 == 1 && fn2 == 1 && fd2 == 1){
//			System.out.println("nichts wurde gekürzt");
		}else{
			strReturn +="$\\frac{";
			
			if(fn1 > 1){strReturn += n1+" \\cdot "+fn1;}
			else{strReturn += n1;}
			
			strReturn += "}{";
			
			if(fd1 > 1){strReturn += d1+" \\cdot "+fd1;}
			else{strReturn += d1;}
			
			strReturn += "}"; //close denominator
			strReturn += "\\cdot";
			strReturn +="\\frac{";
			
			if(fn2 > 1){strReturn += n2+" \\cdot "+fn2;}
			else{strReturn += n2;}
			
			strReturn += "}{";
			
			if(fd2 > 1){strReturn += d2+" \\cdot "+fd2;}
			else{strReturn += d2;}
			
			strReturn += "}$"; //close denominator
			strReturn += " = ";
			strReturn += "$\\frac{"+n1+" \\cdot "+n2+"}{"+d1+" \\cdot "+d2+"}$";
			strReturn += " = ";
		}
//		System.out.println("strReturn = "+strReturn);
		return strReturn;
	}//writeReduction
}
