/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jaas;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jaas.JAASGroup;
import org.mortbay.jaas.JAASRole;
import org.mortbay.jaas.RoleCheckPolicy;
import org.mortbay.jaas.StrictRoleCheckPolicy;

public class JAASUserPrincipal
implements Principal {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jaas$JAASUserPrincipal == null ? (class$org$mortbay$jaas$JAASUserPrincipal = JAASUserPrincipal.class$("org.mortbay.jaas.JAASUserPrincipal")) : class$org$mortbay$jaas$JAASUserPrincipal));
    private Subject subject = null;
    private static RoleStack runAsRoles = new RoleStack();
    private RoleCheckPolicy roleCheckPolicy = null;
    private String name = null;
    static /* synthetic */ Class class$org$mortbay$jaas$JAASUserPrincipal;
    static /* synthetic */ Class class$java$security$acl$Group;
    static /* synthetic */ Class class$org$mortbay$jaas$JAASRole;

    public JAASUserPrincipal(String name) {
        this.name = name;
    }

    public boolean isUserInRole(String roleName) {
        if (this.roleCheckPolicy == null) {
            this.roleCheckPolicy = new StrictRoleCheckPolicy();
        }
        return this.roleCheckPolicy.checkRole(new JAASRole(roleName), runAsRoles.peek(), this.getRoles());
    }

    public Group getRoles() {
        Set roles;
        Group roleGroup = null;
        Set s = this.subject.getPrincipals(class$java$security$acl$Group == null ? (class$java$security$acl$Group = JAASUserPrincipal.class$("java.security.acl.Group")) : class$java$security$acl$Group);
        Iterator itor = s.iterator();
        while (itor.hasNext() && roleGroup == null) {
            Group g = (Group)itor.next();
            if (!g.getName().equalsIgnoreCase("__roles__")) continue;
            roleGroup = g;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Group named \"Roles\"" + (roleGroup == null ? "does not exist" : "does exist")));
        }
        if (roleGroup != null) {
            if (log.isDebugEnabled()) {
                Enumeration members = roleGroup.members();
                while (members.hasMoreElements()) {
                    log.debug((Object)("Member = " + ((Principal)members.nextElement()).getName()));
                }
            }
            return roleGroup;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Trying to find org.mortbay.jaas.JAASRoles instead");
        }
        if (!(roles = this.subject.getPrincipals(class$org$mortbay$jaas$JAASRole == null ? (class$org$mortbay$jaas$JAASRole = JAASUserPrincipal.class$("org.mortbay.jaas.JAASRole")) : class$org$mortbay$jaas$JAASRole)).isEmpty()) {
            roleGroup = new JAASGroup("__roles__");
            itor = roles.iterator();
            while (itor.hasNext()) {
                roleGroup.addMember((Principal)((JAASRole)itor.next()));
            }
            return roleGroup;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"User has no roles");
        }
        return new JAASGroup("__roles__");
    }

    public void setRoleCheckPolicy(RoleCheckPolicy policy) {
        this.roleCheckPolicy = policy;
    }

    public void pushRole(String roleName) {
        RoleStack.push(new JAASRole(roleName));
    }

    public void popRole() {
        runAsRoles.pop();
    }

    public void disassociate() {
        runAsRoles.clear();
    }

    public String getName() {
        return this.name;
    }

    protected void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RoleStack {
        private static ThreadLocal local = new ThreadLocal();

        public static boolean empty() {
            Stack s = (Stack)local.get();
            if (s == null) {
                return false;
            }
            return s.empty();
        }

        public static void push(JAASRole role) {
            Stack<JAASRole> s = (Stack<JAASRole>)local.get();
            if (s == null) {
                s = new Stack<JAASRole>();
                local.set(s);
            }
            s.push(role);
        }

        public static void pop() {
            Stack s = (Stack)local.get();
            if (s == null || s.empty()) {
                return;
            }
            s.pop();
        }

        public static JAASRole peek() {
            Stack s = (Stack)local.get();
            if (s == null || s.empty()) {
                return null;
            }
            return (JAASRole)s.peek();
        }

        public static void clear() {
            Stack s = (Stack)local.get();
            if (s == null || s.empty()) {
                return;
            }
            s.clear();
        }
    }
}

