/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.TestDriver;
import org.objectweb.howl.log.TestWorker;

public class LogTestWorker
extends TestWorker {
    LogTestWorker(TestDriver driver) {
        super(driver);
    }

    long logCommit(int id) throws LogException, Exception {
        this.updateRecordData(id);
        this.bytesLogged += (long)this.commitData.length;
        boolean force = this.msgForceInterval > 0;
        return this.log.put(this.commitDataRecord, force);
    }

    long logInfo() throws LogException, Exception {
        this.bytesLogged += (long)this.infoData.length;
        return this.log.put(this.infoDataRecord, false);
    }

    void logDone(long logkey) throws LogException, Exception {
        this.log.put(this.doneDataRecord, false);
        this.bytesLogged += (long)this.doneData.length;
        ++this.transactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.delayBeforeDone > 0L) {
            this.count = 4;
        }
        try {
            this.driver.getStartBarrier().barrier();
            for (int i = 1; i <= this.count; ++i) {
                long startTime = System.currentTimeMillis();
                long logkey = this.logCommit(i);
                for (int k = 1; k < this.msgForceInterval; ++k) {
                    this.logInfo();
                }
                if (this.delayBeforeDone > 0L) {
                    LogTestWorker.sleep(this.delayBeforeDone);
                }
                this.logDone(logkey);
                this.latency += System.currentTimeMillis() - startTime;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exception = e;
        }
        finally {
            this.driver.getStopBarrier().release();
        }
    }
}

