/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.registry;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;

public class RegistryFireWall {
    private boolean allowAll = true;
    private Hashtable allowedAddress = new Hashtable(11);
    private Hashtable forbidenAddress = new Hashtable(11);

    public boolean isAllow(InetAddress i) {
        if (this.allowAll) {
            return !this.forbidenAddress.contains(i);
        }
        return this.allowedAddress.contains(i);
    }

    public synchronized void allowAll() {
        this.allowAll = true;
        this.allowedAddress.clear();
        this.forbidenAddress.clear();
    }

    public synchronized void forbidAll() {
        this.allowAll = false;
        this.allowedAddress.clear();
        this.forbidenAddress.clear();
    }

    public synchronized void addForbidenAddress(InetAddress i) {
        if (this.allowedAddress.contains(i)) {
            this.allowedAddress.remove(i);
        }
        this.forbidenAddress.put(i, i);
    }

    public synchronized void addAllowedAddress(InetAddress i) {
        if (this.forbidenAddress.contains(i)) {
            this.forbidenAddress.remove(i);
        }
        this.allowedAddress.put(i, i);
    }

    public InetAddress[] listForbidenAddress() {
        int i = this.forbidenAddress.size();
        InetAddress[] result = new InetAddress[i];
        Enumeration enumeration = this.forbidenAddress.keys();
        while (--i >= 0) {
            result[i] = (InetAddress)enumeration.nextElement();
        }
        return result;
    }

    public InetAddress[] listAllowedAddress() {
        int i = this.allowedAddress.size();
        InetAddress[] result = new InetAddress[i];
        Enumeration enumeration = this.allowedAddress.keys();
        while (--i >= 0) {
            result[i] = (InetAddress)enumeration.nextElement();
        }
        return result;
    }

    public boolean isAllowAll() {
        return this.allowAll;
    }
}

