/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.ftp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.ftp.CmdReply;
import org.mortbay.ftp.FtpCmdStreamException;
import org.mortbay.ftp.FtpException;
import org.mortbay.ftp.FtpReplyException;
import org.mortbay.util.LineInput;

class CmdReplyStream {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$ftp$CmdReplyStream == null ? (class$org$mortbay$ftp$CmdReplyStream = CmdReplyStream.class$("org.mortbay.ftp.CmdReplyStream")) : class$org$mortbay$ftp$CmdReplyStream));
    private LineInput in;
    static /* synthetic */ Class class$org$mortbay$ftp$CmdReplyStream;

    CmdReplyStream(InputStream in) {
        this.in = new LineInput(in);
    }

    CmdReply readReply() throws FtpException, IOException {
        String line;
        CmdReply reply = new CmdReply();
        boolean multiLine = false;
        while ((line = this.in.readLine()) != null) {
            if (multiLine) {
                if (line.length() > 3 && line.startsWith(reply.code)) {
                    if (line.charAt(3) == ' ') {
                        reply.text = reply.text + "\n" + line.substring(4);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Reply=" + reply));
                        }
                        return reply;
                    }
                    if (line.charAt(3) == '-') {
                        reply.text = reply.text + "\n" + line.substring(4);
                        continue;
                    }
                    reply.text = reply.text + "\n" + line;
                    continue;
                }
                reply.text = reply.text + "\n" + line;
                continue;
            }
            if (line.length() > 3 && line.charAt(0) >= '0' && line.charAt(0) <= '9' && line.charAt(1) >= '0' && line.charAt(1) <= '9' && line.charAt(2) >= '0' && line.charAt(2) <= '9') {
                reply.code = line.substring(0, 3);
                reply.text = line.substring(4);
                if (line.charAt(3) == ' ') {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Reply=" + reply));
                    }
                    return reply;
                }
                if (line.charAt(3) == '-') {
                    multiLine = true;
                    continue;
                }
                throw new FtpCmdStreamException("Bad code separator", line);
            }
            throw new FtpCmdStreamException("Bad reply format", line);
        }
        return null;
    }

    CmdReply waitForReply(String code) throws FtpException, IOException {
        CmdReply reply = this.readReply();
        if (reply == null) {
            throw new FtpCmdStreamException();
        }
        if (!reply.code.equals(code)) {
            throw new FtpReplyException(reply);
        }
        return reply;
    }

    CmdReply waitForPreliminaryOK() throws FtpException, IOException {
        CmdReply reply = this.readReply();
        if (reply == null) {
            throw new FtpCmdStreamException();
        }
        if (!reply.preliminary() || !reply.positive()) {
            throw new FtpReplyException(reply);
        }
        return reply;
    }

    CmdReply waitForCompleteOK() throws FtpException, IOException {
        CmdReply reply;
        while ((reply = this.readReply()) != null) {
            if (!reply.positive()) {
                throw new FtpReplyException(reply);
            }
            if (!reply.transferComplete()) continue;
        }
        if (reply == null) {
            throw new FtpCmdStreamException();
        }
        return reply;
    }

    CmdReply waitForIntermediateOK() throws FtpException, IOException {
        CmdReply reply = this.readReply();
        if (reply == null) {
            throw new FtpCmdStreamException();
        }
        if (reply.transferComplete() || reply.preliminary() || !reply.positive()) {
            throw new FtpReplyException(reply);
        }
        return reply;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

