/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jaas.spi;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jaas.JAASGroup;
import org.mortbay.jaas.JAASPrincipal;
import org.mortbay.jaas.JAASRole;
import org.mortbay.jaas.callback.ObjectCallback;
import org.mortbay.util.Credential;
import org.mortbay.util.Loader;

public class JDBCLoginModule
implements LoginModule {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jaas$spi$JDBCLoginModule == null ? (class$org$mortbay$jaas$spi$JDBCLoginModule = JDBCLoginModule.class$("org.mortbay.jaas.spi.JDBCLoginModule")) : class$org$mortbay$jaas$spi$JDBCLoginModule));
    private CallbackHandler callbackHandler = null;
    private boolean authState = false;
    private boolean commitState = false;
    private Subject subject = null;
    private Principal principal = null;
    private Credential credential = null;
    private Group roleGroup = null;
    private String dbCredential = null;
    private String dbDriver;
    private String dbUrl;
    private String dbUserName;
    private String dbPassword;
    private String userQuery;
    private String rolesQuery;
    static /* synthetic */ Class class$org$mortbay$jaas$spi$JDBCLoginModule;

    public boolean abort() throws LoginException {
        this.principal = null;
        this.credential = null;
        this.roleGroup = null;
        this.dbCredential = null;
        return this.authState && this.commitState;
    }

    public boolean commit() throws LoginException {
        if (!this.authState) {
            this.principal = null;
            this.credential = null;
            this.roleGroup = null;
            this.commitState = false;
            this.dbCredential = null;
            return this.authState;
        }
        this.subject.getPrincipals().add(this.principal);
        this.subject.getPrivateCredentials().add(this.credential);
        this.subject.getPrincipals().add((Principal)this.roleGroup);
        this.commitState = true;
        this.dbCredential = null;
        return true;
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No callback handler");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Enter user name"), new ObjectCallback()};
        try {
            this.callbackHandler.handle(callbacks);
            String webUserName = ((NameCallback)callbacks[0]).getName();
            Object webCredential = ((ObjectCallback)callbacks[1]).getObject();
            if (webUserName == null) {
                this.authState = false;
                return this.authState;
            }
            if (webCredential == null) {
                this.authState = false;
                return this.authState;
            }
            this.loadUser(webUserName);
            this.principal = new JAASPrincipal(webUserName);
            if (this.dbCredential == null) {
                this.authState = false;
                return this.authState;
            }
            this.credential = Credential.getCredential((String)this.dbCredential);
            this.authState = this.credential.check(webCredential);
            return this.authState;
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.toString());
        }
        catch (SQLException e) {
            throw new LoginException(e.toString());
        }
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.subject.getPrivateCredentials().remove(this.credential);
        this.subject.getPrincipals().remove(this.roleGroup);
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        try {
            this.dbDriver = (String)options.get("dbDriver");
            this.dbUrl = (String)options.get("dbUrl");
            this.dbUserName = (String)options.get("dbUserName");
            this.dbPassword = (String)options.get("dbPassword");
            if (this.dbUserName == null) {
                this.dbUserName = "";
            }
            if (this.dbPassword == null) {
                this.dbPassword = "";
            }
            if (this.dbDriver != null) {
                Loader.loadClass(this.getClass(), (String)this.dbDriver).newInstance();
            }
            String dbUserTable = (String)options.get("userTable");
            String dbUserTableUserField = (String)options.get("userField");
            String dbUserTableCredentialField = (String)options.get("credentialField");
            this.userQuery = "select " + dbUserTableCredentialField + " from " + dbUserTable + " where " + dbUserTableUserField + "=?";
            String dbUserRoleTable = (String)options.get("userRoleTable");
            String dbUserRoleTableUserField = (String)options.get("userRoleUserField");
            String dbUserRoleTableRoleField = (String)options.get("userRoleRoleField");
            this.rolesQuery = "select " + dbUserRoleTableRoleField + " from " + dbUserRoleTable + " where " + dbUserRoleTableUserField + "=?";
            if (log.isDebugEnabled()) {
                log.debug((Object)("userQuery = " + this.userQuery));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("rolesQuery = " + this.rolesQuery));
            }
            this.subject = subject;
            this.callbackHandler = callbackHandler;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUser(String userName) throws SQLException {
        Connection connection = null;
        try {
            if (this.dbDriver == null || this.dbUrl == null) {
                throw new IllegalStateException("Database connection information not configured");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connecting using dbDriver=" + this.dbDriver + "+ dbUserName=" + this.dbUserName + ", dbPassword=" + this.dbUrl));
            }
            connection = DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);
            PreparedStatement statement = connection.prepareStatement(this.userQuery);
            statement.setString(1, userName);
            ResultSet results = statement.executeQuery();
            if (results.next()) {
                this.dbCredential = results.getString(1);
            }
            results.close();
            statement.close();
            statement = connection.prepareStatement(this.rolesQuery);
            statement.setString(1, userName);
            results = statement.executeQuery();
            this.roleGroup = new JAASGroup("__roles__");
            while (results.next()) {
                String roleName = results.getString(1);
                this.roleGroup.addMember((Principal)new JAASRole(roleName));
            }
            results.close();
            statement.close();
        }
        finally {
            connection.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

