/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;
import org.objectweb.carol.cmi.compiler.ClassConf;
import org.objectweb.carol.cmi.compiler.Compiler;
import org.objectweb.carol.cmi.compiler.CompilerException;

public class TemplateCompiler
implements LogSystem {
    private ClassConf ccc;
    private VelocityEngine ve;
    private String clFullName;
    private String clName;
    private String genDirName;
    private String pkgName;
    private Compiler c;

    public TemplateCompiler(Compiler c, ClassConf ccc) throws CompilerException {
        this.c = c;
        this.ccc = ccc;
        this.ve = new VelocityEngine();
        this.ve.setProperty("runtime.log.logsystem", (Object)this);
        this.ve.setProperty("velocimacro.library", (Object)"");
        this.ve.setProperty("resource.loader", (Object)"class");
        this.ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            this.ve.init();
        }
        catch (Exception e1) {
            throw new CompilerException("Velocity engine error", e1);
        }
        this.clFullName = ccc.getClassName();
        int n = this.clFullName.lastIndexOf(".");
        if (n < 0) {
            this.clName = ccc.getClassName();
            this.genDirName = c.getSrcDir();
            this.pkgName = "";
        } else {
            this.pkgName = ccc.getClassName().substring(0, n);
            this.clName = ccc.getClassName().substring(n + 1);
            this.genDirName = c.getSrcDir() + File.separator + this.pkgName.replace('.', File.separatorChar);
        }
    }

    public String genConfig() throws CompilerException {
        Template tmpl;
        try {
            tmpl = this.ve.getTemplate("org/objectweb/carol/cmi/compiler/ClusterConfigTemplate.vm");
        }
        catch (Exception e1) {
            throw new CompilerException("Velocity engine error", e1);
        }
        VelocityContext vc = this.createVelocityContext();
        String fileName = this.clName + "_ClusterConfig.java";
        return this.generate(tmpl, vc, fileName);
    }

    public String genStub() throws CompilerException {
        Template tmpl;
        try {
            tmpl = this.ve.getTemplate("org/objectweb/carol/cmi/compiler/ClusterStubTemplate.vm");
        }
        catch (Exception e1) {
            throw new CompilerException("Velocity engine error", e1);
        }
        VelocityContext vc = this.createVelocityContext();
        String fileName = this.clName + "_Cluster.java";
        return this.generate(tmpl, vc, fileName);
    }

    private String generate(Template tmpl, VelocityContext vc, String fileName) throws CompilerException {
        FileWriter fw;
        String fullFileName = this.genDirName + File.separator + fileName;
        try {
            File dir = new File(this.genDirName);
            dir.mkdirs();
        }
        catch (Exception e) {
            throw new CompilerException("unable to create directory " + this.genDirName, e);
        }
        try {
            File file = new File(this.genDirName, fileName);
            fw = new FileWriter(file);
        }
        catch (Exception e) {
            throw new CompilerException("unable to create file " + fileName, e);
        }
        try {
            tmpl.merge((Context)vc, (Writer)fw);
            fw.flush();
            fw.close();
        }
        catch (CompilerException ce) {
            throw ce;
        }
        catch (Exception e2) {
            throw new CompilerException(fullFileName, e2);
        }
        return fullFileName;
    }

    private VelocityContext createVelocityContext() throws CompilerException {
        VelocityContext vc = new VelocityContext();
        vc.put("className", (Object)this.clName);
        vc.put("pkgName", (Object)this.pkgName);
        vc.put("classFullName", (Object)this.clFullName);
        vc.put("classConf", (Object)this.ccc);
        return vc;
    }

    public void init(RuntimeServices arg0) throws Exception {
    }

    public void logVelocityMessage(int arg0, String arg1) {
    }
}

