/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.multi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.objectweb.carol.util.configuration.TraceCarol;
import org.objectweb.carol.util.multi.ProtocolCurrent;

public class MultiPRODelegate
implements PortableRemoteObjectDelegate {
    private static boolean init = false;
    private static Hashtable exported = new Hashtable();
    private static Hashtable activesProtocols = null;
    private static ProtocolCurrent pcur = null;

    public MultiPRODelegate() throws RemoteException {
        if (TraceCarol.isDebugRmiCarol()) {
            TraceCarol.debugRmiCarol("MultiPRODelegate.MultiPRODelegate()");
        }
        try {
            this.initProtocols();
        }
        catch (Exception e) {
            String msg = "MultiPRODelegate, init protocols fail";
            TraceCarol.error(msg, e);
            throw new RemoteException(msg);
        }
    }

    public void exportObject(Remote obj) throws RemoteException {
        if (TraceCarol.isDebugRmiCarol()) {
            TraceCarol.debugRmiCarol("MultiPRODelegate.exportObject(" + this.simpleClass(obj.getClass().getName()) + " obj)");
        }
        try {
            if (!init) {
                this.initProtocols();
            }
            Enumeration e = activesProtocols.elements();
            while (e.hasMoreElements()) {
                ((PortableRemoteObjectDelegate)e.nextElement()).exportObject(obj);
            }
            if (TraceCarol.isDebugExportCarol()) {
                TraceCarol.debugExportCarol("Export object " + obj.getClass().getName());
                this.addObject(obj.getClass().getName());
            }
        }
        catch (Exception ex) {
            String msg = "MultiPRODelegate.exportObject(Remote obj) fail";
            TraceCarol.error(msg, ex);
            throw new RemoteException(msg);
        }
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        if (TraceCarol.isDebugRmiCarol()) {
            TraceCarol.debugRmiCarol("MultiPRODelegate.unexportObject(" + this.simpleClass(obj.getClass().getName()) + " obj)");
        }
        try {
            if (!init) {
                this.initProtocols();
            }
            Enumeration e = activesProtocols.elements();
            while (e.hasMoreElements()) {
                ((PortableRemoteObjectDelegate)e.nextElement()).unexportObject(obj);
            }
            if (TraceCarol.isDebugExportCarol()) {
                TraceCarol.debugExportCarol("Unexport object " + obj.getClass().getName());
                TraceCarol.debugExportCarol("UnExported objects list:\n" + this.getUnexportedObjects());
                this.removeObject(obj.getClass().getName());
            }
        }
        catch (Exception ex) {
            String msg = "MultiPRODelegate.unexportObject(Remote obj) fail";
            TraceCarol.error(msg, ex);
            throw new NoSuchObjectException(msg);
        }
    }

    public void connect(Remote target, Remote source) throws RemoteException {
        if (TraceCarol.isDebugRmiCarol()) {
            TraceCarol.debugRmiCarol("MultiPRODelegate.connect(" + this.simpleClass(target.getClass().getName()) + " target," + this.simpleClass(source.getClass().getName()) + " source)");
        }
        try {
            if (!init) {
                this.initProtocols();
            }
            Enumeration e = activesProtocols.elements();
            while (e.hasMoreElements()) {
                ((PortableRemoteObjectDelegate)e.nextElement()).connect(target, source);
            }
        }
        catch (Exception e) {
            String msg = "MultiPRODelegate.connect(Remote target,Remote source) fail";
            TraceCarol.error(msg, e);
            throw new RemoteException(msg);
        }
    }

    public Object narrow(Object obj, Class newClass) throws ClassCastException {
        if (TraceCarol.isDebugRmiCarol()) {
            TraceCarol.debugRmiCarol("MultiPRODelegate.narrow(" + this.simpleClass(obj.getClass().getName()) + " obj," + this.simpleClass(newClass.getName()) + " class)/rmi name=\"" + pcur.getCurrentRMIName() + "\"");
        }
        try {
            if (init) {
                return pcur.getCurrentPortableRemoteObject().narrow(obj, newClass);
            }
            this.initProtocols();
            return pcur.getCurrentPortableRemoteObject().narrow(obj, newClass);
        }
        catch (Exception e) {
            String msg = "MultiPRODelegate.narrow(Object obj, Class newClass) fail";
            TraceCarol.error(msg, e);
            throw new ClassCastException(msg);
        }
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        if (TraceCarol.isDebugRmiCarol()) {
            TraceCarol.debugRmiCarol("MultiPRODelegate.toStub(" + this.simpleClass(obj.getClass().getName()) + " obj)/rmi name=\"" + pcur.getCurrentRMIName() + "\"");
        }
        try {
            if (init) {
                return pcur.getCurrentPortableRemoteObject().toStub(obj);
            }
            this.initProtocols();
            return pcur.getCurrentPortableRemoteObject().toStub(obj);
        }
        catch (Exception e) {
            String msg = "MultiPRODelegate.toStub(Remote obj) fail";
            TraceCarol.error(msg, e);
            throw new NoSuchObjectException(msg);
        }
    }

    private void initProtocols() throws Exception {
        if (TraceCarol.isDebugRmiCarol()) {
            TraceCarol.debugRmiCarol("MultiPRODelegate.initProtocols()");
        }
        pcur = ProtocolCurrent.getCurrent();
        activesProtocols = pcur.getPortableRemoteObjectHashtable();
        init = true;
    }

    private String simpleClass(String c) {
        return c.substring(c.lastIndexOf(46) + 1);
    }

    private String getUnexportedObjects() {
        String result = "Exported Objects:\n";
        int resultInt = 0;
        Enumeration e = exported.keys();
        while (e.hasMoreElements()) {
            String ck = (String)e.nextElement();
            int on = (Integer)exported.get(ck);
            result = result + "" + on + " instances of  " + ck + "\n";
            resultInt += on;
        }
        result = result + "Total number of exported objects=" + resultInt;
        return result;
    }

    private void removeObject(String className) {
        if (exported.containsKey(className)) {
            if ((Integer)exported.get(className) != 1) {
                exported.put(className, new Integer((Integer)exported.get(className) - 1));
            } else {
                exported.remove(className);
            }
        }
    }

    private void addObject(String className) {
        if (exported.containsKey(className)) {
            exported.put(className, new Integer((Integer)exported.get(className) + 1));
        } else {
            exported.put(className, new Integer(1));
        }
    }
}

