/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.io.Serializable;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.carol.cmi.ClusterConfig;
import org.objectweb.carol.cmi.ClusterObject;
import org.objectweb.carol.cmi.ClusterRegistry;
import org.objectweb.carol.cmi.ClusterRegistryKiller;
import org.objectweb.carol.cmi.ClusterStub;
import org.objectweb.carol.cmi.ConfigException;
import org.objectweb.carol.cmi.DistributedEquiv;
import org.objectweb.carol.cmi.LowerOrb;
import org.objectweb.carol.util.configuration.TraceCarol;

public final class ClusterRegistryImpl
implements ClusterRegistry {
    private HashMap lreg = new HashMap();
    public static final String REG_PREFIX = "REG_";

    private ClusterRegistryImpl() {
    }

    public static ClusterRegistryKiller start(int port) throws RemoteException {
        if (TraceCarol.isDebugCmiRegistry()) {
            TraceCarol.debugCmiRegistry("registry starting on port " + port);
        }
        ClusterRegistryImpl creg = new ClusterRegistryImpl();
        ClusterRegistry stub = (ClusterRegistry)LowerOrb.exportRegistry(creg, port);
        ClusterRegistryKiller k = new ClusterRegistryKiller(creg, port);
        return k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote lookup(String n) throws NotBoundException, RemoteException {
        Object obj;
        HashMap hashMap = this.lreg;
        synchronized (hashMap) {
            obj = this.lreg.get(n);
        }
        if (obj != null) {
            if (TraceCarol.isDebugCmiRegistry()) {
                TraceCarol.debugCmiRegistry("local lookup of " + n);
            }
            return (Remote)obj;
        }
        try {
            ClusterStub cs;
            if (TraceCarol.isDebugCmiRegistry()) {
                TraceCarol.debugCmiRegistry("global lookup of " + n);
            }
            if ((cs = DistributedEquiv.getGlobal((Serializable)((Object)(REG_PREFIX + n)))) != null) {
                if (TraceCarol.isDebugCmiRegistry()) {
                    TraceCarol.debugCmiRegistry("returned a cluster stub");
                }
                return cs;
            }
        }
        catch (ConfigException e) {
            throw new RemoteException(e.toString());
        }
        throw new NotBoundException(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String n, Remote obj) throws AlreadyBoundException, RemoteException {
        ClusterConfig cc;
        block13: {
            cc = null;
            try {
                cc = ClusterObject.getClusterConfig(obj);
                if (TraceCarol.isDebugCmiRegistry()) {
                    TraceCarol.debugCmiRegistry("Global bind of " + n);
                }
            }
            catch (Exception e) {
                if (!TraceCarol.isDebugCmiRegistry()) break block13;
                TraceCarol.debugCmiRegistry("Local bind of " + n);
            }
        }
        HashMap hashMap = this.lreg;
        synchronized (hashMap) {
            if (cc == null) {
                Object cur = this.lreg.get(n);
                if (cur != null) {
                    throw new AlreadyBoundException(n);
                }
                this.lreg.put(n, obj);
            } else {
                if (!cc.isGlobalAtBind()) {
                    throw new RemoteException("not implemented");
                }
                try {
                    if (!DistributedEquiv.exportObject((Serializable)((Object)(REG_PREFIX + n)), obj)) {
                        throw new AlreadyBoundException(n);
                    }
                }
                catch (ConfigException e) {
                    throw new RemoteException(e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String n) throws NotBoundException, RemoteException {
        HashMap hashMap = this.lreg;
        synchronized (hashMap) {
            Object obj = this.lreg.remove(n);
            if (obj != null) {
                if (TraceCarol.isDebugCmiRegistry()) {
                    TraceCarol.debugCmiRegistry("Local unbind of " + n);
                }
                return;
            }
            if (TraceCarol.isDebugCmiRegistry()) {
                TraceCarol.debugCmiRegistry("Global unbind of " + n);
            }
            try {
                if (!DistributedEquiv.unexportObject((Serializable)((Object)(REG_PREFIX + n)))) {
                    throw new NotBoundException(n);
                }
            }
            catch (ConfigException e) {
                throw new RemoteException(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(String n, Remote obj) throws RemoteException {
        ClusterConfig cc;
        block11: {
            cc = null;
            try {
                cc = ClusterObject.getClusterConfig(obj);
                if (TraceCarol.isDebugCmiRegistry()) {
                    TraceCarol.debugCmiRegistry("Global rebind of " + n);
                }
            }
            catch (Exception e) {
                if (!TraceCarol.isDebugCmiRegistry()) break block11;
                TraceCarol.debugCmiRegistry("Local rebind of " + n);
            }
        }
        HashMap hashMap = this.lreg;
        synchronized (hashMap) {
            if (cc == null) {
                this.lreg.put(n, obj);
            } else {
                if (!cc.isGlobalAtBind()) {
                    throw new RemoteException("not implemented");
                }
                try {
                    String name = REG_PREFIX + n;
                    DistributedEquiv.unexportObject((Serializable)((Object)name));
                    DistributedEquiv.exportObject((Serializable)((Object)name), obj);
                }
                catch (ConfigException e) {
                    throw new RemoteException(e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list() throws RemoteException {
        Iterator<Object> it;
        TreeSet<String> s = new TreeSet<String>();
        try {
            Set global = DistributedEquiv.keySet();
            Iterator it2 = global.iterator();
            while (it2.hasNext()) {
                String str;
                Object o = it2.next();
                if (!(o instanceof String) || !(str = (String)o).startsWith(REG_PREFIX)) continue;
                s.add(str.substring(4));
            }
        }
        catch (ConfigException e) {
            throw new RemoteException(e.toString());
        }
        HashMap hashMap = this.lreg;
        synchronized (hashMap) {
            Set local = this.lreg.keySet();
            it = local.iterator();
            while (it.hasNext()) {
                s.add((String)it.next());
            }
        }
        int n = s.size();
        it = s.iterator();
        String[] tab = new String[n];
        int i = 0;
        while (i < n) {
            tab[i] = (String)it.next();
            ++i;
        }
        return tab;
    }

    public void test() throws RemoteException {
    }

    public static void main(String[] args) throws Exception {
        DistributedEquiv.start();
        ClusterRegistryImpl.start(Integer.parseInt(args[0]));
        System.out.println("Cluster service started");
        while (true) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException e) {
            }
        }
    }
}

