/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.shared;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.shared.AbstractHttpSessionImpl;
import org.codehaus.wadi.shared.ObjectInputStream;

class Wrapper
implements Serializable {
    protected static final transient Log _log;
    protected transient AbstractHttpSessionImpl _ahsi;
    protected transient boolean _isActive;
    protected transient Object _activeValue;
    protected byte[] _passiveValue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.codehaus.wadi.shared.Wrapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = LogFactory.getLog((Class)clazz);
    }

    public Wrapper(AbstractHttpSessionImpl ahsi, Object value) {
        this._ahsi = ahsi;
        this._isActive = true;
        this._activeValue = value;
    }

    public synchronized Object getValue(AbstractHttpSessionImpl ahsi) {
        if (!this._isActive) {
            this.activate(ahsi);
        }
        return this._activeValue;
    }

    public synchronized void setValue(Object value) {
        this._passiveValue = null;
        this._activeValue = value;
        this._isActive = true;
    }

    protected void activate(AbstractHttpSessionImpl ahsi) {
        this._ahsi = ahsi;
        if (this._activeValue == null && this._passiveValue != null) {
            this._activeValue = ObjectInputStream.demarshall(this._passiveValue);
        }
        if (_log.isTraceEnabled()) {
            _log.trace((Object)(String.valueOf(this._ahsi.getRealId()) + " : activate: " + this._passiveValue + " --> " + this._activeValue));
        }
        this._passiveValue = null;
        this._isActive = true;
        if (this._activeValue != null && this._activeValue instanceof HttpSessionActivationListener) {
            ((HttpSessionActivationListener)this._activeValue).sessionDidActivate(new HttpSessionEvent(this._ahsi.getFacade()));
        }
    }

    protected void passivate() {
        if (this._activeValue != null && this._activeValue instanceof HttpSessionActivationListener) {
            ((HttpSessionActivationListener)this._activeValue).sessionWillPassivate(new HttpSessionEvent(this._ahsi.getFacade()));
        }
        this._passiveValue = ObjectInputStream.marshall(this._activeValue);
        this._isActive = false;
        if (_log.isTraceEnabled()) {
            _log.trace((Object)(String.valueOf(this._ahsi.getRealId()) + " : passivate: " + this._activeValue + " --> " + this._passiveValue));
        }
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        if (this._isActive) {
            this.passivate();
        }
        out.defaultWriteObject();
    }

    private synchronized void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String toString() {
        return "" + (this._isActive ? this._activeValue : (Object)this._passiveValue);
    }
}

