/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.shared;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.Mutex;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.plugins.FilePassivationStrategy;
import org.codehaus.wadi.plugins.NoRoutingStrategy;
import org.codehaus.wadi.plugins.RelativeEvictionPolicy;
import org.codehaus.wadi.plugins.SimpleStreamingStrategy;
import org.codehaus.wadi.plugins.TomcatIdGenerator;
import org.codehaus.wadi.plugins.TotalEvictionPolicy;
import org.codehaus.wadi.shared.Counting;
import org.codehaus.wadi.shared.DiscoveryService;
import org.codehaus.wadi.shared.EvictionPolicy;
import org.codehaus.wadi.shared.Filter;
import org.codehaus.wadi.shared.HttpSession;
import org.codehaus.wadi.shared.HttpSessionImpl;
import org.codehaus.wadi.shared.IdGenerator;
import org.codehaus.wadi.shared.ManagerProxy;
import org.codehaus.wadi.shared.MigrationService;
import org.codehaus.wadi.shared.PassivationStrategy;
import org.codehaus.wadi.shared.RWLock;
import org.codehaus.wadi.shared.RoutingStrategy;
import org.codehaus.wadi.shared.StreamingStrategy;
import org.mortbay.xml.XmlConfiguration;

public abstract class Manager {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final Map _local = new ConcurrentReaderHashMap();
    protected final Map _migrating = new HashMap();
    protected ThreadLocal _firstGet = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.TRUE;
        }
    };
    protected int _maxInactiveInterval = 1800;
    protected boolean _distributable = false;
    protected EvictionPolicy _evictionPolicy;
    protected PassivationStrategy _passivationStrategy;
    protected boolean _running = false;
    protected ClassLoader _loader;
    protected String _configurationResource = "WEB-INF/wadi-web.xml";
    protected IdGenerator _idGenerator;
    protected final List _sessionListeners = new ArrayList();
    protected final List _attributeListeners = new ArrayList();
    protected InetAddress _autoLocationAddress = null;
    protected int _autoLocationPort = 6789;
    protected int _autoLocationTimeout = 5;
    protected LocationServer _locationServer;
    protected LocationClient _locationClient;
    protected RoutingStrategy _routingStrategy;
    MigrationService.Server _migrationServer;
    protected int _sessionCreationCounter = 0;
    protected int _sessionDestructionCounter = 0;
    protected int _sessionExpirationCounter = 0;
    protected int _sessionInvalidationCounter = 0;
    protected int _sessionRejectionCounter = 0;
    protected int _sessionLoadCounter;
    protected int _sessionStoreCounter;
    protected int _sessionSendCounter;
    protected int _sessionReceivedCounter;
    protected int _sessionLocalHitCounter;
    protected int _sessionStoreHitCounter;
    protected int _sessionRemoteHitCounter;
    protected int _sessionMissCounter;
    protected int _requestAcceptedCounter;
    protected int _requestRedirectedCounter;
    protected int _requestProxiedCounter;
    protected int _requestStatefulCounter;
    protected int _requestStatelessCounter;
    boolean _reuseSessionIds = false;
    protected StreamingStrategy _streamingStrategy;
    protected Filter _filter;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.codehaus.wadi.shared.Manager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public HttpSessionImpl put(String realId, HttpSessionImpl session) {
        return this._local.put(realId, session);
    }

    public boolean owns(String realId) {
        if (this._local.containsKey(realId)) {
            return true;
        }
        Map map = this._migrating;
        synchronized (map) {
            return this._migrating.containsKey(realId);
        }
    }

    public void setFirstGet(boolean b) {
        this._firstGet.set(b ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getFirstGet() {
        return (Boolean)this._firstGet.get();
    }

    public HttpSessionImpl get(String realId) {
        HttpSessionImpl impl = this.getLocalSession(realId);
        if (this.getFirstGet()) {
            this.setFirstGet(false);
            if (impl != null) {
                try {
                    impl.getApplicationLock().acquire();
                }
                catch (InterruptedException e) {
                    this._log.warn((Object)"unexpected interruption", (Throwable)e);
                }
            }
            if (impl == null) {
                impl = this.getRemoteSession(realId);
            }
        }
        return impl;
    }

    protected HttpSessionImpl getLocalSession(String realId) {
        return (HttpSessionImpl)this._local.get(realId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected HttpSessionImpl getRemoteSession(String realId) {
        HttpSessionImpl impl = null;
        Mutex oldMigrationLock = null;
        Mutex newMigrationLock = new Mutex();
        try {
            try {
                ManagerProxy proxy;
                block22: {
                    newMigrationLock.acquire();
                    Map map = this._migrating;
                    // MONITORENTER : map
                    impl = this.getLocalSession(realId);
                    if (impl == null) break block22;
                    HttpSessionImpl httpSessionImpl = impl;
                    // MONITOREXIT : map
                    Object var9_9 = null;
                    newMigrationLock.release();
                    return httpSessionImpl;
                }
                oldMigrationLock = (Mutex)this._migrating.get(realId);
                if (oldMigrationLock == null) {
                    this._migrating.put(realId, newMigrationLock);
                }
                // MONITOREXIT : map
                if (oldMigrationLock != null) {
                    try {
                        oldMigrationLock.acquire();
                        HttpSessionImpl httpSessionImpl = this.getLocalSession(realId);
                        Object var6_16 = null;
                        oldMigrationLock.release();
                        Object var9_10 = null;
                        newMigrationLock.release();
                        return httpSessionImpl;
                    }
                    catch (InterruptedException e) {
                        HttpSessionImpl httpSessionImpl;
                        try {
                            this._log.warn((Object)"unexpected interruption whilst waiting for existing migration to finish", (Throwable)e);
                            httpSessionImpl = null;
                            Object var6_17 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_18 = null;
                            oldMigrationLock.release();
                            throw throwable;
                        }
                        oldMigrationLock.release();
                        Object var9_11 = null;
                        newMigrationLock.release();
                        return httpSessionImpl;
                    }
                }
                boolean successfulMigration = false;
                impl = this.createImpl();
                if (this._passivationStrategy != null) {
                    successfulMigration = this._passivationStrategy.activate(realId, impl);
                }
                if (!successfulMigration && (proxy = this.locate(realId)) != null) {
                    successfulMigration = proxy.relocateSession(this._local, this._migrating, realId, impl, this._streamingStrategy);
                }
                if (successfulMigration) {
                    if (!$assertionsDisabled && impl == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && impl.getRealId() == null) {
                        throw new AssertionError();
                    }
                    this._acquireImpl(impl);
                } else {
                    this._releaseImpl(impl);
                    impl = null;
                }
                this._migrating.remove(realId);
            }
            catch (InterruptedException interruptedException) {
                this._log.warn((Object)"unexpected interruption acquiring new migration lock");
            }
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            newMigrationLock.release();
            throw throwable;
        }
        newMigrationLock.release();
        return impl;
    }

    public HttpSessionImpl remove(String realId) {
        return (HttpSessionImpl)this._local.remove(realId);
    }

    public Collection values() {
        return this._local.values();
    }

    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int seconds) {
        this._maxInactiveInterval = seconds;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public boolean getDistributable() {
        return this._distributable;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this._evictionPolicy;
    }

    public void setEvictionPolicy(EvictionPolicy policy) {
        this._evictionPolicy = policy;
    }

    public PassivationStrategy getPassivationStrategy() {
        return this._passivationStrategy;
    }

    public void setPassivationStrategy(PassivationStrategy policy) {
        this._passivationStrategy = policy;
    }

    public ClassLoader getLoader() {
        return this._loader;
    }

    public void setLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public synchronized void start() throws Exception {
        Class<?> clazz;
        ServletContext ctx;
        block14: {
            this._log.debug((Object)"starting");
            this._log.info((Object)"WADI-0.9 - Web Application Distribution Infrastructure (http://wadi.codehaus.org)");
            ctx = this.getServletContext();
            try {
                InputStream is = ctx.getResourceAsStream(this._configurationResource);
                if (is != null) {
                    new XmlConfiguration(is).configure((Object)this);
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("configured from: " + this._configurationResource));
                    }
                }
            }
            catch (Exception e) {
                if (!this._log.isWarnEnabled()) break block14;
                this._log.warn((Object)("problem configuring from: " + this._configurationResource), (Throwable)e);
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.codehaus.wadi.shared.Manager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ctx.setAttribute(clazz.getName(), (Object)this);
        this._loader = Thread.currentThread().getContextClassLoader();
        if (this._passivationStrategy == null) {
            this._passivationStrategy = new FilePassivationStrategy(new File("/tmp/wadi"));
        }
        if (this._streamingStrategy == null) {
            this._streamingStrategy = new SimpleStreamingStrategy();
        }
        if (this._passivationStrategy.getStreamingStrategy() == null) {
            this._passivationStrategy.setStreamingStrategy(this._streamingStrategy);
        }
        if (this._evictionPolicy == null) {
            this._evictionPolicy = new RelativeEvictionPolicy(0.5f);
        }
        if (this._idGenerator == null) {
            this._idGenerator = new TomcatIdGenerator();
        }
        if (this._routingStrategy == null) {
            this._routingStrategy = new NoRoutingStrategy();
        }
        if (this._autoLocationAddress == null) {
            this.setAutoLocationAddress("228.5.6.7");
        }
        this._locationServer = new LocationServer(this.getAutoLocationAddress(), this.getAutoLocationPort(), 5000L, InetAddress.getLocalHost(), this.getHttpPort());
        this._locationClient = new LocationClient(this.getAutoLocationAddress(), this.getAutoLocationPort(), 5000L);
        this._locationServer.start();
        this._migrationServer = new MigrationService.Server(this._local, this._migrating, this._streamingStrategy);
        this._migrationServer.start();
        this._running = true;
        this._log.debug((Object)"started");
    }

    public synchronized boolean isStarted() {
        return this._running;
    }

    public synchronized void stop() throws Exception {
        this._log.debug((Object)"stopping");
        this._running = false;
        if (this.getDistributable() && this._passivationStrategy != null) {
            EvictionPolicy oldEvictionPolicy = this._evictionPolicy;
            this._evictionPolicy = new TotalEvictionPolicy();
            int oldSize = this._local.size();
            this.housekeeper();
            int newSize = this._local.size();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("emmigrated " + (oldSize - newSize) + "/" + oldSize + " sessions"));
            }
            this._evictionPolicy = oldEvictionPolicy;
        }
        this._locationServer.stop();
        this._locationServer = null;
        this._migrationServer.stop();
        this._migrationServer = null;
        this._loader = null;
        this._log.debug((Object)"stopped");
    }

    public void tidyStore(long currentTime) {
        if (this._passivationStrategy.isElected()) {
            LinkedList list = new LinkedList();
            Collection c = this._passivationStrategy.findTimedOut(currentTime, list);
            int n = c.size();
            if (n > 0) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("tidying up " + n + " session[s] expired in long-term storage"));
                }
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    HttpSessionImpl impl = this.createImpl();
                    if (this._passivationStrategy.activate((String)i.next(), impl)) {
                        impl.setWadiManager(this);
                        this._notify(impl);
                        this._releaseImpl(impl);
                        continue;
                    }
                    this.destroyImpl(impl);
                }
                list.clear();
            }
            this._passivationStrategy.standDown();
        } else {
            this._passivationStrategy.standUp();
        }
    }

    public boolean setPriority(RWLock lock, int priority) {
        lock.setPriority(priority);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void housekeeper() throws InterruptedException {
        boolean canEvict;
        this._log.trace((Object)"housekeeping beginning");
        long currentTime = System.currentTimeMillis();
        boolean bl = canEvict = this.getDistributable() && this._passivationStrategy != null && this._evictionPolicy != null;
        if (canEvict) {
            this.tidyStore(currentTime);
        }
        Iterator i = this._local.values().iterator();
        while (true) {
            if (!i.hasNext()) {
                this._log.trace((Object)"housekeeping ended");
                return;
            }
            HttpSessionImpl impl = (HttpSessionImpl)i.next();
            RWLock lock = impl.getRWLock();
            boolean hasTimedOut = false;
            boolean shouldBeEvicted = false;
            boolean nottried = true;
            hasTimedOut = impl.hasTimedOut(currentTime);
            if ((hasTimedOut && this.setPriority(lock, 3) || (shouldBeEvicted = canEvict && this._evictionPolicy.evictable(currentTime, impl)) && this.setPriority(lock, 1)) && (nottried = impl.getContainerLock().attempt(100L))) {
                Object var11_10;
                block12: {
                    block13: {
                        block11: {
                            try {
                                String realId = impl.getRealId();
                                if (hasTimedOut) {
                                    if (this._log.isTraceEnabled()) {
                                        this._log.trace((Object)(String.valueOf(realId) + " : removing (implicit time out)"));
                                    }
                                    if (this._log.isDebugEnabled()) {
                                        this._log.debug((Object)(String.valueOf(realId) + " : timed out"));
                                    }
                                    this.releaseImpl(impl);
                                    var11_10 = null;
                                    break block11;
                                }
                                if (!shouldBeEvicted) break block12;
                                if (this._log.isTraceEnabled()) {
                                    this._log.trace((Object)(String.valueOf(realId) + " : removing (migrating to long-term store)"));
                                }
                                if (!this._passivationStrategy.passivate(impl)) break block13;
                                this._local.remove(realId);
                                impl.destroy();
                                break block13;
                            }
                            catch (Throwable throwable) {
                                var11_10 = null;
                                impl.getContainerLock().release();
                                throw throwable;
                            }
                        }
                        impl.getContainerLock().release();
                        continue;
                    }
                    var11_10 = null;
                    impl.getContainerLock().release();
                    continue;
                }
                var11_10 = null;
                impl.getContainerLock().release();
                continue;
            }
            if (nottried || !this._log.isInfoEnabled()) continue;
            this._log.info((Object)("tried but failed for lock on:" + impl.getRealId() + " - " + impl.getRWLock()));
        }
    }

    public String getSpecificationVersion() {
        return "2.4";
    }

    public IdGenerator getIdGenerator() {
        return this._idGenerator;
    }

    public void setIdGenerator(IdGenerator generator) {
        this._idGenerator = generator;
    }

    public List getSessionListeners() {
        return this._sessionListeners;
    }

    public List getAttributeListeners() {
        return this._attributeListeners;
    }

    public synchronized void addEventListener(EventListener listener) throws IllegalArgumentException, IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("EventListeners must be added before a Session Manager starts");
        }
        boolean known = false;
        if (listener instanceof HttpSessionAttributeListener) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("adding HttpSessionAttributeListener: " + listener));
            }
            this._attributeListeners.add(listener);
            known = true;
        }
        if (listener instanceof HttpSessionListener) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("adding HttpSessionListener: " + listener));
            }
            this._sessionListeners.add(listener);
            known = true;
        }
        if (!known) {
            throw new IllegalArgumentException("Unknown EventListener type " + listener);
        }
    }

    public synchronized void removeEventListener(EventListener listener) throws IllegalStateException {
        boolean known = false;
        if (this.isStarted()) {
            throw new IllegalStateException("EventListeners may not be removed while a Session Manager is running");
        }
        if (listener instanceof HttpSessionAttributeListener) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("removing HttpSessionAttributeListener: " + listener));
            }
            known |= this._attributeListeners.remove(listener);
        }
        if (listener instanceof HttpSessionListener) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("removing HttpSessionListener: " + listener));
            }
            known |= this._sessionListeners.remove(listener);
        }
        if (!known && this._log.isWarnEnabled()) {
            this._log.warn((Object)("EventListener not registered: " + listener));
        }
    }

    public void notifySessionCreated(String realId, javax.servlet.http.HttpSession session) {
        try {
            int n = this._sessionListeners.size();
            if (n > 0) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)(String.valueOf(realId) + " : notifying session creation"));
                }
                HttpSessionEvent event = new HttpSessionEvent(session);
                int i = 0;
                while (i < n) {
                    this.notifySessionCreated((HttpSessionListener)this._sessionListeners.get(i), event);
                    ++i;
                }
                event = null;
            }
        }
        finally {
            Counting.aspectOf().ajc$after$org_codehaus_wadi_shared_Counting$1$a13e1a45(this);
        }
    }

    public void notifySessionDestroyed(String realId, javax.servlet.http.HttpSession session) {
        try {
            int n = this._sessionListeners.size();
            if (n > 0) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)(String.valueOf(realId) + " : notifying session destruction"));
                }
                HttpSessionEvent event = new HttpSessionEvent(session);
                int i = 0;
                while (i < n) {
                    this.notifySessionDestroyed((HttpSessionListener)this._sessionListeners.get(i), event);
                    ++i;
                }
                event = null;
            }
        }
        finally {
            Counting.aspectOf().ajc$after$org_codehaus_wadi_shared_Counting$2$4af0f1d2(this);
        }
    }

    protected void notifySessionAttributeAdded(String realId, javax.servlet.http.HttpSession session, String key, Object val) {
        int n = this._attributeListeners.size();
        if (n > 0) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)(String.valueOf(realId) + " : notifying attribute addition : " + key + " : null --> " + val));
            }
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, key, val);
            int i = 0;
            while (i < n) {
                this.notifySessionAttributeAdded((HttpSessionAttributeListener)this._attributeListeners.get(i), event);
                ++i;
            }
            event = null;
        }
    }

    protected void notifySessionAttributeReplaced(String realId, javax.servlet.http.HttpSession session, String key, Object oldVal, Object newVal) {
        int n = this._attributeListeners.size();
        if (n > 0) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)(String.valueOf(realId) + " : notifying attribute replacement : " + key + " : " + oldVal + " --> " + newVal));
            }
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, key, oldVal);
            int i = 0;
            while (i < n) {
                this.notifySessionAttributeReplaced((HttpSessionAttributeListener)this._attributeListeners.get(i), event);
                ++i;
            }
            event = null;
        }
    }

    protected void notifySessionAttributeRemoved(String realId, javax.servlet.http.HttpSession session, String key, Object val) {
        int n = this._attributeListeners.size();
        if (n > 0) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)(String.valueOf(realId) + " : notifying attribute removal : " + key + " : " + val + " --> null"));
            }
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, key, val);
            int i = 0;
            while (i < n) {
                this.notifySessionAttributeRemoved((HttpSessionAttributeListener)this._attributeListeners.get(i), event);
                ++i;
            }
            event = null;
        }
    }

    public void notifySessionCreated(HttpSessionListener listener, HttpSessionEvent event) {
        listener.sessionCreated(event);
    }

    public void notifySessionDestroyed(HttpSessionListener listener, HttpSessionEvent event) {
        listener.sessionDestroyed(event);
    }

    public void notifySessionAttributeAdded(HttpSessionAttributeListener listener, HttpSessionBindingEvent event) {
        listener.attributeAdded(event);
    }

    public void notifySessionAttributeRemoved(HttpSessionAttributeListener listener, HttpSessionBindingEvent event) {
        listener.attributeRemoved(event);
    }

    public void notifySessionAttributeReplaced(HttpSessionAttributeListener listener, HttpSessionBindingEvent event) {
        listener.attributeReplaced(event);
    }

    public void replicate(String realId, Method method, Object[] args) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("replicating delta: " + realId + " -> " + method));
        }
    }

    public void invoke(String realId, Method method, Object[] args) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("invoking delta: " + realId + " -> " + method));
        }
    }

    public InetAddress getAutoLocationAddress() {
        return this._autoLocationAddress;
    }

    public void setAutoLocationAddress(InetAddress address) {
        this._autoLocationAddress = address;
    }

    public void setAutoLocationAddress(String address) {
        block2: {
            try {
                this.setAutoLocationAddress(InetAddress.getByName(address));
            }
            catch (Exception e) {
                if (!this._log.isWarnEnabled()) break block2;
                this._log.warn((Object)("could not resolve address: " + address), (Throwable)e);
            }
        }
    }

    public int getAutoLocationPort() {
        return this._autoLocationPort;
    }

    public void setAutoLocationPort(int port) {
        this._autoLocationPort = port;
    }

    public int getAutoLocationTimeout() {
        return this._autoLocationTimeout;
    }

    public void setAutoLocationTimeout(int timeout) {
        this._autoLocationTimeout = timeout;
    }

    public ManagerProxy locate(String realId) {
        String location = this._locationClient.run("org.codehaus.wadi,locate," + realId);
        if (location == null) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)(String.valueOf(realId) + ": could not locate session - perhaps dead ?"));
            }
            return null;
        }
        try {
            return new ManagerProxy(realId, location);
        }
        catch (Exception e) {
            this._log.warn((Object)"bad location response", (Throwable)e);
            return null;
        }
    }

    public RoutingStrategy getRoutingStrategy() {
        return this._routingStrategy;
    }

    public void setRoutingStrategy(RoutingStrategy routingStrategy) {
        this._routingStrategy = routingStrategy;
    }

    public abstract String getSessionCookieName();

    public abstract String getSessionCookiePath(HttpServletRequest var1);

    public abstract String getSessionCookieDomain();

    public abstract String getSessionUrlParamName();

    public abstract boolean isServing(InetAddress var1, int var2);

    public abstract int getHttpPort();

    public abstract ServletContext getServletContext();

    public abstract HttpSessionContext getSessionContext();

    public void setSessionCreationCounter(int n) {
        this._sessionCreationCounter = n;
    }

    public int getSessionCreationCounter() {
        return this._sessionCreationCounter;
    }

    public void setSessionDestructionCounter(int n) {
        this._sessionDestructionCounter = n;
    }

    public int getSessionDestructionCounter() {
        return this._sessionDestructionCounter;
    }

    public void setSessionExpirationCounter(int n) {
        this._sessionExpirationCounter = n;
    }

    public int getSessionExpirationCounter() {
        return this._sessionExpirationCounter;
    }

    public void setSessionInvalidationCounter(int n) {
        this._sessionInvalidationCounter = n;
    }

    public int getSessionInvalidationCounter() {
        return this._sessionInvalidationCounter;
    }

    public void setSessionRejectionCounter(int n) {
        this._sessionRejectionCounter = n;
    }

    public int getSessionRejectionCounter() {
        return this._sessionRejectionCounter;
    }

    public void setSessionLoadCounter(int n) {
        this._sessionLoadCounter = n;
    }

    public int getSessionLoadCounter() {
        return this._sessionLoadCounter;
    }

    public void setSessionStoreCounter(int n) {
        this._sessionStoreCounter = n;
    }

    public int getSessionStoreCounter() {
        return this._sessionStoreCounter;
    }

    public void setSessionSendCounter(int n) {
        this._sessionSendCounter = n;
    }

    public int getSessionSendCounter() {
        return this._sessionSendCounter;
    }

    public void setSessionReceivedCounter(int n) {
        this._sessionReceivedCounter = n;
    }

    public int getSessionReceivedCounter() {
        return this._sessionReceivedCounter;
    }

    public void setSessionLocalHitCounter(int n) {
        this._sessionLocalHitCounter = n;
    }

    public int getSessionLocalHitCounter() {
        return this._sessionLocalHitCounter;
    }

    public void setSessionStoreHitCounter(int n) {
        this._sessionStoreHitCounter = n;
    }

    public int getSessionStoreHitCounter() {
        return this._sessionStoreHitCounter;
    }

    public void setSessionRemoteHitCounter(int n) {
        this._sessionRemoteHitCounter = n;
    }

    public int getSessionRemoteHitCounter() {
        return this._sessionRemoteHitCounter;
    }

    public void setSessionMissCounter(int n) {
        this._sessionMissCounter = n;
    }

    public int getSessionMissCounter() {
        return this._sessionMissCounter;
    }

    public void setRequestAcceptedCounter(int n) {
        this._requestAcceptedCounter = n;
    }

    public int getRequestAcceptedCounter() {
        return this._requestAcceptedCounter;
    }

    public void setRequestRedirectedCounter(int n) {
        this._requestRedirectedCounter = n;
    }

    public int getRequestRedirectedCounter() {
        return this._requestRedirectedCounter;
    }

    public void setRequestProxiedCounter(int n) {
        this._requestProxiedCounter = n;
    }

    public int getRequestProxiedCounter() {
        return this._requestProxiedCounter;
    }

    public void setRequestStatefulCounter(int n) {
        this._requestStatefulCounter = n;
    }

    public int getRequestStatefulCounter() {
        return this._requestStatefulCounter;
    }

    public void setRequestStatelessCounter(int n) {
        this._requestStatelessCounter = n;
    }

    public int getRequestStatelessCounter() {
        return this._requestStatelessCounter;
    }

    protected HttpSessionImpl acquireImpl(Manager manager) {
        return this.acquireImpl(manager, null);
    }

    protected HttpSessionImpl acquireImpl(Manager manager, String realId) {
        if (realId == null) {
            realId = (String)this.getIdGenerator().take();
        }
        HttpSessionImpl impl = this.createImpl();
        impl.init(this, realId, System.currentTimeMillis(), this._maxInactiveInterval, this._maxInactiveInterval);
        this._acquireImpl(impl);
        this.notifySessionCreated(realId, impl.getFacade());
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(String.valueOf(realId) + ": creation"));
        }
        return impl;
    }

    protected void _acquireImpl(HttpSessionImpl impl) {
        impl.setWadiManager(this);
        try {
            impl.getApplicationLock().acquire();
        }
        catch (InterruptedException interruptedException) {
            this._log.warn((Object)"unable to acquire rlock on new session");
        }
        this._local.put(impl.getRealId(), impl);
    }

    protected void _notify(HttpSessionImpl impl) {
        HttpSession session = (HttpSession)impl.getFacade();
        String realId = impl.getRealId();
        session.setValid(true);
        if ("2.4".equals(this.getSpecificationVersion())) {
            this.notifySessionDestroyed(realId, session);
        }
        String[] names = session.getValueNames();
        int len = names.length;
        int i = 0;
        while (i < len) {
            session.removeAttribute(names[i]);
            ++i;
        }
        names = null;
        if ("2.3".equals(this.getSpecificationVersion())) {
            this.notifySessionDestroyed(realId, session);
        }
        session.setValid(false);
    }

    protected void releaseImpl(HttpSessionImpl impl) {
        String realId = impl.getRealId();
        this._local.remove(realId);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(String.valueOf(realId) + ": destruction"));
        }
        this._notify(impl);
        this._releaseImpl(impl);
    }

    protected void _releaseImpl(HttpSessionImpl impl) {
        impl.setWadiManager(null);
        impl.destroy();
        this.destroyImpl(impl);
    }

    protected abstract HttpSessionImpl createImpl();

    protected abstract void destroyImpl(HttpSessionImpl var1);

    public boolean getReuseSessionIds() {
        return this._reuseSessionIds;
    }

    public StreamingStrategy getStreamingStrategy() {
        return this._streamingStrategy;
    }

    public void setStreamingStrategy(StreamingStrategy streamingStrategy) {
        this._streamingStrategy = streamingStrategy;
    }

    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    class LocationClient
    extends DiscoveryService.Client {
        public LocationClient(InetAddress address, int port, long timeout) {
            super(address, port, timeout);
        }
    }

    class LocationServer
    extends DiscoveryService.Server {
        protected long _timeout;
        protected InetAddress _httpIpAddress;
        protected int _httpPort;

        public LocationServer(InetAddress serverIpAddress, int serverPort, long timeout, InetAddress httpIpAddress, int httpPort) {
            super(serverIpAddress, serverPort);
            this._timeout = 2000L;
            this._httpIpAddress = httpIpAddress;
            this._httpPort = httpPort;
        }

        public String process(String request) {
            String response = null;
            String[] params = request.split(",");
            if (params.length == 3 && params[0].equals("org.codehaus.wadi") && params[1].equals("locate") && Manager.this._local.containsKey(params[2])) {
                response = "org.codehaus.wadi,locate," + params[2] + "," + this._httpIpAddress.getHostAddress() + "," + this._httpPort + "," + Manager.this._migrationServer.getAddress().getHostAddress() + "," + Manager.this._migrationServer.getPort() + "," + Manager.this._routingStrategy.getInfo();
            }
            return response;
        }
    }
}

