/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.plugins;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.shared.IdGenerator;

public class TomcatIdGenerator
implements IdGenerator {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected StringManager sm = new StringManager();
    protected Support support = new Support();
    protected DataInputStream randomIS = null;
    protected String devRandomSource = "/dev/urandom";
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected String algorithm = "MD5";
    protected MessageDigest digest = null;
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected String entropy = null;

    public Object poll(long millis) {
        return this.take();
    }

    public Object take() {
        return this.generateSessionId();
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    public synchronized Random getRandom() {
        if (this.random == null) {
            TomcatIdGenerator tomcatIdGenerator = this;
            synchronized (tomcatIdGenerator) {
                if (this.random == null) {
                    long seed;
                    long t1 = seed = System.currentTimeMillis();
                    char[] entropy = this.getEntropy().toCharArray();
                    int i = 0;
                    while (i < entropy.length) {
                        long update = (byte)entropy[i] << i % 8 * 8;
                        seed ^= update;
                        ++i;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.randomClass);
                        this.random = (Random)clazz.newInstance();
                        this.random.setSeed(seed);
                    }
                    catch (Exception e) {
                        this.log.error((Object)this.sm.getString("managerBase.random", this.randomClass), (Throwable)e);
                        this.random = new Random();
                        this.random.setSeed(seed);
                    }
                    long t2 = System.currentTimeMillis();
                    if (t2 - t1 > 100L) {
                        this.log.debug((Object)(String.valueOf(this.sm.getString("managerBase.seeding", this.randomClass)) + " " + (t2 - t1)));
                    }
                }
            }
        }
        return this.random;
    }

    public void setRandomFile(String s) {
        if (System.getSecurityManager() != null) {
            this.randomIS = (DataInputStream)AccessController.doPrivileged(new PrivilegedSetRandomFile());
        } else {
            try {
                this.devRandomSource = s;
                File f = new File(this.devRandomSource);
                if (!f.exists()) {
                    return;
                }
                this.randomIS = new DataInputStream(new FileInputStream(f));
                this.randomIS.readLong();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Opening " + this.devRandomSource));
                }
            }
            catch (IOException iOException) {
                this.randomIS = null;
            }
        }
    }

    protected synchronized String generateSessionId() {
        byte[] bytes = new byte[16];
        this.getRandomBytes(bytes);
        bytes = this.getDigest().digest(bytes);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
            } else {
                result.append((char)(65 + (b2 - 10)));
            }
            ++i;
        }
        return result.toString();
    }

    public synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            long t1 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.sm.getString("managerBase.getting", this.algorithm));
            }
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error((Object)this.sm.getString("managerBase.digest", this.algorithm), (Throwable)e);
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.log.error((Object)this.sm.getString("managerBase.digest", DEFAULT_ALGORITHM), (Throwable)e);
                    this.digest = null;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.sm.getString("managerBase.gotten"));
            }
            long t2 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getDigest() " + (t2 - t1)));
            }
        }
        return this.digest;
    }

    protected void getRandomBytes(byte[] bytes) {
        if (this.devRandomSource != null && this.randomIS == null) {
            this.setRandomFile(this.devRandomSource);
        }
        if (this.randomIS != null) {
            try {
                int len = this.randomIS.read(bytes);
                if (len == bytes.length) {
                    return;
                }
                this.log.debug((Object)("Got " + len + " " + bytes.length));
            }
            catch (Exception exception) {}
            this.devRandomSource = null;
            this.randomIS = null;
        }
        this.getRandom();
        this.getRandom().nextBytes(bytes);
    }

    class StringManager {
        StringManager() {
        }

        String getString(String s) {
            return s;
        }

        String getString(String s, String a) {
            return "[" + a + "]: " + s;
        }
    }

    class Support {
        Support() {
        }

        void firePropertyChange(String s, Object oldVal, Object newVal) {
        }
    }

    private class PrivilegedSetRandomFile
    implements PrivilegedAction {
        PrivilegedSetRandomFile() {
        }

        public Object run() {
            try {
                File f = new File(TomcatIdGenerator.this.devRandomSource);
                if (!f.exists()) {
                    return null;
                }
                TomcatIdGenerator.this.randomIS = new DataInputStream(new FileInputStream(f));
                TomcatIdGenerator.this.randomIS.readLong();
                if (TomcatIdGenerator.this.log.isDebugEnabled()) {
                    TomcatIdGenerator.this.log.debug((Object)("Opening " + TomcatIdGenerator.this.devRandomSource));
                }
                return TomcatIdGenerator.this.randomIS;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

