/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.loadbalancer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.mortbay.loadbalancer.ByteBufferPool;
import org.mortbay.loadbalancer.Connection;
import org.mortbay.util.Code;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.LifeCycleThread;
import org.mortbay.util.Log;

public class Server
extends LifeCycleThread {
    Selector _selector;
    InetSocketAddress _address;
    ByteBufferPool _bufferPool;
    ArrayList _pending = new ArrayList();

    public Server() throws IOException {
    }

    public Server(ByteBufferPool pool, InetSocketAddress address) throws IOException {
        this._address = address;
        this._bufferPool = pool;
    }

    public Server(ByteBufferPool pool, InetAddrPort address) throws IOException {
        this._address = new InetSocketAddress(address.getInetAddress(), address.getPort());
        this._bufferPool = pool;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this._address;
    }

    public void setInetSocketAddress(InetSocketAddress address) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._address = address;
    }

    public ByteBufferPool getBufferPool() {
        return this._bufferPool;
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this._bufferPool = bufferPool;
    }

    public synchronized void connect(Connection connection) throws IOException {
        SocketChannel socket_channel = SocketChannel.open();
        socket_channel.configureBlocking(false);
        Code.debug((Object)"Connecting... ", (Object)socket_channel);
        if (socket_channel.connect(this._address)) {
            connection.connected(socket_channel, this._selector);
        }
        this._pending.add(socket_channel);
        this._pending.add(connection);
        Code.debug((Object)"wakeup ", (Object)this._selector);
        this._selector.wakeup();
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._selector = Selector.open();
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop() throws Exception {
        Code.debug((Object)"server keys=", this._selector.keys());
        if (this._selector.select() > 0) {
            Set<SelectionKey> ready = this._selector.selectedKeys();
            Iterator<SelectionKey> iter = ready.iterator();
            while (iter.hasNext()) {
                SelectionKey key = iter.next();
                iter.remove();
                SelectableChannel channel = key.channel();
                if (Code.debug()) {
                    Code.debug((String)("Ready key " + key + " for " + channel));
                }
                if (!channel.isOpen()) {
                    key.cancel();
                    continue;
                }
                if (!(channel instanceof SocketChannel)) continue;
                SocketChannel socket_channel = (SocketChannel)channel;
                Connection connection = (Connection)key.attachment();
                if ((key.interestOps() & 8) != 0) {
                    boolean connected = false;
                    try {
                        connected = socket_channel.finishConnect();
                    }
                    catch (Exception e) {
                        if (Code.debug()) {
                            Code.warning((Throwable)e);
                        } else {
                            Log.event((Object)e.toString());
                        }
                        key.cancel();
                        connection.deallocate();
                    }
                    if (connected) {
                        connection.connected(socket_channel, this._selector);
                        socket_channel.socket().setTcpNoDelay(true);
                        key.interestOps(key.interestOps() & 0xFFFFFFF7 | 1);
                        continue;
                    }
                    Code.debug((Object)"Not Connected ", (Object)socket_channel);
                    continue;
                }
                if ((key.interestOps() & 4) != 0) {
                    connection.serverWriteWakeup(key);
                    continue;
                }
                if ((key.interestOps() & 1) == 0) continue;
                connection.server2client(key);
            }
        }
        Server server = this;
        synchronized (server) {
            int i = 0;
            while (i < this._pending.size()) {
                SocketChannel sc = (SocketChannel)this._pending.get(i++);
                Connection c = (Connection)this._pending.get(i);
                Code.debug((Object)"register ", (Object)sc);
                sc.register(this._selector, sc.isConnected() ? 4 : 8, c);
                ++i;
            }
            this._pending.clear();
        }
    }
}

