/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus;

import java.io.IOException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.Code;
import org.mortbay.util.TypeUtil;
import org.mortbay.xml.XmlParser;

public class JotmWebAppContext
extends WebApplicationContext {
    Context _rootComp;
    Context _rootCompEnv;

    public JotmWebAppContext() {
    }

    public JotmWebAppContext(String webApp) {
        super(webApp);
    }

    public void start() throws Exception {
        this.bindToGlobal("javax.transaction.UserTransaction", "java:comp/UserTransaction");
        super.start();
    }

    protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
        if ("env-entry".equals(element)) {
            String name = node.getString("env-entry-name", false, true);
            Object value = TypeUtil.valueOf((String)node.getString("env-entry-type", false, true), (String)node.getString("env-entry-value", false, true));
            this.bind("java:comp/env/" + name, value);
        } else if ("resource-ref".equals(element)) {
            String name = node.getString("res-ref-name", false, true);
            this.bindToGlobal(name, "java:comp/env/" + name);
        } else if ("resource-env-ref".equals(element)) {
            String name = node.getString("resource-env-ref-name", false, true);
            this.bindToGlobal(name, "java:comp/env/" + name);
        } else if ("ejb-ref".equals(element) || "ejb-local-ref".equals(element) || "security-domain".equals(element)) {
            Code.warning((String)("Entry " + element + " => " + node + " is not supported yet"));
        } else {
            super.initWebXmlElement(element, node);
        }
    }

    public boolean handle(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        return super.handle(request, response);
    }

    private void bind(String name, Object value) throws NamingException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            Code.warning((Throwable)e);
            throw e;
        }
        Code.debug((Object)"bind in ", (Object)ctx, (Object)" ", (Object)name, (Object)"=", (Object)value);
        ctx.rebind(name, value);
        Code.debug((String)("Entry bound in JNDI with name " + name));
    }

    private void bindToGlobal(String strGlobalName, String name) throws NamingException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            Code.warning((Throwable)e);
            throw e;
        }
        Code.debug((String)("Searching for global entry in JNDI with name " + strGlobalName));
        Object objValue = ctx.lookup(strGlobalName);
        Code.debug((String)("Found global entry in JNDI with name " + strGlobalName));
        Code.debug((Object)"bind in ", (Object)ctx, (Object)" ", (Object)name, (Object)"=", (Object)objValue);
        ctx.rebind(name, objValue);
        Code.debug((String)("Entry bound in JNDI with name " + name));
    }
}

