/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jetty.log;

import java.util.HashMap;
import org.jboss.logging.Logger;
import org.mortbay.util.Code;
import org.mortbay.util.Frame;
import org.mortbay.util.LogSink;

public class JBossLogSink
implements LogSink {
    Logger _log;
    boolean _started = false;
    HashMap _dispatch = new HashMap();

    public JBossLogSink() {
        this._dispatch.put("DEBUG  ", new MyLogger(){

            public void log(String s) {
                if (JBossLogSink.this._log.isDebugEnabled()) {
                    JBossLogSink.this._log.debug((Object)s);
                } else {
                    JBossLogSink.this._log.info((Object)("DEBUG: " + s));
                }
            }
        });
        this._dispatch.put("EVENT  ", new MyLogger(){

            public void log(String s) {
                JBossLogSink.this._log.info((Object)s);
            }
        });
        this._dispatch.put("WARN!! ", new MyLogger(){

            public void log(String s) {
                JBossLogSink.this._log.warn((Object)("WARNING: " + s));
            }
        });
        this._dispatch.put("ASSERT ", new MyLogger(){

            public void log(String s) {
                JBossLogSink.this._log.error((Object)s);
            }
        });
        this._dispatch.put("FAIL!! ", new MyLogger(){

            public void log(String s) {
                JBossLogSink.this._log.error((Object)s);
            }
        });
    }

    public void initialize(Object log) throws InterruptedException {
        this._log = (Logger)log;
    }

    public void start() {
        this._started = true;
    }

    public void stop() throws InterruptedException {
        this._started = false;
    }

    public void destroy() {
        this._log = null;
    }

    public boolean isStarted() {
        return this._started;
    }

    public boolean isDestroyed() {
        return this._log == null;
    }

    public void setOptions(String dateFormat, String timezone, boolean logTimeStamps, boolean logLabels, boolean logTags, boolean logStackSize, boolean logStackTrace, boolean logOneLine) {
    }

    public void setOptions(String logOptions) {
    }

    public String getOptions() {
        return "";
    }

    public void log(String tag, Object msg, Frame frame, long time) {
        boolean debugging = Code.debug();
        MyLogger logger = (MyLogger)this._dispatch.get(tag);
        if (logger != null) {
            logger.log(msg + (debugging ? ", " + frame : ""));
        } else {
            this.log(msg + " - " + tag + (debugging ? ", " + frame : ""));
            this._log.warn((Object)("JBossLogSink doesn't understand tag: '" + tag + "'"));
        }
    }

    public synchronized void log(String formattedLog) {
        this._log.info((Object)formattedLog);
    }

    static interface MyLogger {
        public void log(String var1);
    }
}

