/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.util.configuration.TraceCarol;

public class JRMPRegistry
implements NameService {
    public int port = 1099;
    public Registry registry = null;

    public void start() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JRMPRegistry.start() on port:" + this.port);
        }
        try {
            if (!this.isStarted()) {
                if (this.port >= 0) {
                    this.registry = LocateRegistry.createRegistry(this.port);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                JRMPRegistry.this.stop();
                            }
                            catch (Exception e) {
                                TraceCarol.error("JRMPRegistry ShutdownHook problem", e);
                            }
                        }
                    });
                } else if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Can't start JRMPRegistry, port=" + this.port + " is < 0");
                }
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("JRMPRegistry is already start on port:" + this.port);
            }
        }
        catch (Exception e) {
            throw new NameServiceException("can not start rmi registry: " + e);
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JRMPRegistry.stop()");
        }
        try {
            if (this.registry != null) {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
            this.registry = null;
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop rmi registry: " + e);
        }
    }

    public boolean isStarted() {
        if (this.registry != null) {
            return true;
        }
        try {
            LocateRegistry.getRegistry(this.port).list();
        }
        catch (RemoteException re) {
            return false;
        }
        return true;
    }

    public void setPort(int p) {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JRMPRegistry.setPort(" + p + ")");
        }
        if (p != 0) {
            this.port = p;
        }
    }
}

