# Detect product
function sun_j2re_detect() {
    local found=
    case "$archive_name" in
	"j2re-1_3_1_"[0-9][0-9]"-linux-i586.bin")
	    j2se_version="1.3.1+${archive_name:11:2}"
	    j2se_expected_min_size=38 # 39089 kB
	    found=true
	    ;;
	"j2re-1_4_2-linux-i586.bin")
	    j2se_version=1.4.2
	    j2se_expected_min_size=56 # 58000 kB
	    found=true
	    ;;
	"j2re-1_4_2_"[0-9][0-9]"-linux-i586.bin")
	    j2se_version="1.4.2+${archive_name:11:2}"
	    j2se_expected_min_size=56 # 58093 kB
	    found=true
	    ;;
	"j2re-1_5_0-beta2-linux-i586.bin")
	    j2se_version=1.5.0+beta2
	    j2se_expected_min_size=81 # 83267 kB
	    found=true
	    ;;
    esac
    if [[ -n "$found" ]]; then
	cat << EOF

Detected product:
    Java(TM) Runtime Environment (J2RE)
    Standard Edition, Version $j2se_version
    Sun Microsystems(TM), Inc.
EOF
	if read_yn "Is this correct [Y/n]: "; then
	    j2se_found=true
	    j2se_release="${j2se_version:0:3}"
	    j2se_required_space=$(( $j2se_expected_min_size * 2 + 20 ))
	    j2se_vendor="sun"
	    j2se_title="Java(TM) 2 RE, Standard Edition, Sun Microsystems(TM)"
	    j2re_run
	fi
    fi
}

j2se_detect_sun_j2re=sun_j2re_detect
