/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.TextFilterable;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.filter.BoyerMooreCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.SingleCharacterCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.StartsWithCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TextMatcher
implements Matcher {
    private static final Comparator LENGTH_COMPARATOR = new StringLengthComparator();
    private final TextFilterator filterator;
    private final String[] filters;
    private final int mode;
    private final TextSearchStrategy[] filterStrategies;
    private final List filterStrings = new ArrayList();

    public TextMatcher(String[] filters, TextFilterator filterator, int mode) {
        this.filterator = filterator;
        this.filters = filters;
        this.mode = mode;
        this.filterStrategies = new TextSearchStrategy[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            this.filterStrategies[i] = TextMatcher.selectTextSearchStrategy(filters[i], mode);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public String[] getFilters() {
        return this.filters;
    }

    public boolean matches(Object element) {
        this.filterStrings.clear();
        if (this.filterator == null) {
            ((TextFilterable)element).getFilterStrings(this.filterStrings);
        } else {
            this.filterator.getFilterStrings(this.filterStrings, element);
        }
        block0: for (int f = 0; f < this.filterStrategies.length; ++f) {
            TextSearchStrategy textSearchStrategy = this.filterStrategies[f];
            for (int c = 0; c < this.filterStrings.size(); ++c) {
                Object filterString = this.filterStrings.get(c);
                if (filterString != null && textSearchStrategy.indexOf(filterString.toString()) != -1) continue block0;
            }
            return false;
        }
        return true;
    }

    private static TextSearchStrategy selectTextSearchStrategy(String filter, int mode) {
        TextSearchStrategy result;
        if (mode == 0) {
            result = filter.length() == 1 ? new SingleCharacterCaseInsensitiveTextSearchStrategy() : new BoyerMooreCaseInsensitiveTextSearchStrategy();
        } else if (mode == 1) {
            result = new StartsWithCaseInsensitiveTextSearchStrategy();
        } else {
            throw new IllegalArgumentException("unrecognized mode: " + mode);
        }
        result.setSubtext(filter);
        return result;
    }

    public static String[] normalizeFilters(String[] filterStrings) {
        int i;
        boolean[] minimalFilter = new boolean[filterStrings.length];
        int validFilters = 0;
        for (i = 0; i < filterStrings.length; ++i) {
            if (filterStrings[i] == null || filterStrings[i].length() <= 0) continue;
            ++validFilters;
            minimalFilter[i] = true;
        }
        block1: for (i = 0; i < minimalFilter.length; ++i) {
            if (!minimalFilter[i]) continue;
            for (int j = 0; j < minimalFilter.length; ++j) {
                if (!minimalFilter[j] || i == j || filterStrings[j].indexOf(filterStrings[i]) == -1) continue;
                minimalFilter[i] = false;
                --validFilters;
                continue block1;
            }
        }
        ArrayList<String> minimalFilters = new ArrayList<String>(validFilters);
        int i2 = 0;
        int j = 0;
        while (j < validFilters) {
            if (minimalFilter[i2]) {
                minimalFilters.add(filterStrings[i2]);
                ++j;
            }
            ++i2;
        }
        Collections.sort(minimalFilters, LENGTH_COMPARATOR);
        return minimalFilters.toArray(new String[validFilters]);
    }

    public static boolean isFilterEqual(String[] oldFilters, String[] newFilters) {
        int j;
        int i;
        block0: for (i = 0; i < newFilters.length; ++i) {
            for (j = 0; j < oldFilters.length; ++j) {
                if (oldFilters[j].equals(newFilters[i])) continue block0;
            }
            return false;
        }
        block2: for (i = 0; i < oldFilters.length; ++i) {
            for (j = 0; j < newFilters.length; ++j) {
                if (newFilters[j].equals(oldFilters[i])) continue block2;
            }
            return false;
        }
        return true;
    }

    public static boolean isFilterRelaxed(String[] oldFilters, String[] newFilters) {
        int j;
        int i;
        block0: for (i = 0; i < newFilters.length; ++i) {
            for (j = 0; j < oldFilters.length; ++j) {
                if (oldFilters[j].indexOf(newFilters[i]) != -1) continue block0;
            }
            return false;
        }
        block2: for (i = 0; i < oldFilters.length; ++i) {
            for (j = 0; j < newFilters.length; ++j) {
                if (newFilters[j].indexOf(oldFilters[i]) != -1) continue block2;
            }
            return true;
        }
        return false;
    }

    public static boolean isFilterConstrained(String[] oldFilter, String[] newFilter) {
        return TextMatcher.isFilterRelaxed(newFilter, oldFilter);
    }

    private static final class StringLengthComparator
    implements Comparator {
        private StringLengthComparator() {
        }

        public int compare(Object x0, Object x1) {
            String s1 = (String)x0;
            String s2 = (String)x1;
            return s2.length() - s1.length();
        }
    }
}

