/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.event.BlockSequence;
import ca.odell.glazedlists.impl.adt.barcode2.FourColorTree;
import ca.odell.glazedlists.impl.adt.barcode2.FourColorTreeIterator;
import ca.odell.glazedlists.impl.adt.barcode2.ListToByteCoder;
import java.util.Arrays;

class Tree4Deltas {
    private static final String LIST_CHANGE = "*";
    private static final ListToByteCoder BYTE_CODER = new ListToByteCoder(Arrays.asList("+", "U", "X", "_"));
    private static final byte INSERT = BYTE_CODER.colorToByte("+");
    private static final byte UPDATE = BYTE_CODER.colorToByte("U");
    private static final byte DELETE = BYTE_CODER.colorToByte("X");
    private static final byte NO_CHANGE = BYTE_CODER.colorToByte("_");
    private static final byte SNAPSHOT_INDICES = BYTE_CODER.colorsToByte(Arrays.asList("U", "X", "_"));
    private static final byte CURRENT_INDICES = BYTE_CODER.colorsToByte(Arrays.asList("U", "+", "_"));
    private static final byte ALL_INDICES = BYTE_CODER.colorsToByte(Arrays.asList("U", "X", "+", "_"));
    private static final byte CHANGE_INDICES = BYTE_CODER.colorsToByte(Arrays.asList("U", "X", "+"));
    private FourColorTree tree = new FourColorTree(BYTE_CODER);
    private boolean allowContradictingEvents = false;
    private boolean initialCapacityKnown = false;

    Tree4Deltas() {
    }

    public boolean getAllowContradictingEvents() {
        return this.allowContradictingEvents;
    }

    public void setAllowContradictingEvents(boolean allowContradictingEvents) {
        this.allowContradictingEvents = allowContradictingEvents;
    }

    public int currentToSnapshot(int currentIndex) {
        if (!this.initialCapacityKnown) {
            this.ensureCapacity(currentIndex + 1);
        }
        return this.tree.convertIndexColor(currentIndex, CURRENT_INDICES, SNAPSHOT_INDICES);
    }

    public int snapshotToCurrent(int snapshotIndex) {
        if (!this.initialCapacityKnown) {
            this.ensureCapacity(snapshotIndex + 1);
        }
        return this.tree.convertIndexColor(snapshotIndex, SNAPSHOT_INDICES, CURRENT_INDICES);
    }

    public void update(int startIndex, int endIndex) {
        if (!this.initialCapacityKnown) {
            this.ensureCapacity(endIndex);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            int overallIndex = this.tree.convertIndexColor(i, CURRENT_INDICES, ALL_INDICES);
            if (this.tree.get(overallIndex, ALL_INDICES).getColor() == INSERT) {
                return;
            }
            this.tree.set(overallIndex, ALL_INDICES, UPDATE, LIST_CHANGE, 1);
        }
    }

    public void insert(int startIndex, int endIndex) {
        if (!this.initialCapacityKnown) {
            this.ensureCapacity(endIndex);
        }
        this.tree.add(startIndex, CURRENT_INDICES, INSERT, LIST_CHANGE, endIndex - startIndex);
    }

    public void delete(int startIndex, int endIndex) {
        if (!this.initialCapacityKnown) {
            this.ensureCapacity(endIndex);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            int overallIndex = this.tree.convertIndexColor(startIndex, CURRENT_INDICES, ALL_INDICES);
            if (this.tree.get(overallIndex, ALL_INDICES).getColor() == INSERT) {
                if (!this.allowContradictingEvents) {
                    throw new IllegalStateException("Remove " + i + " undoes prior insert at the same index! Consider enabling contradicting events.");
                }
                this.tree.remove(overallIndex, ALL_INDICES, 1);
                continue;
            }
            this.tree.set(overallIndex, ALL_INDICES, DELETE, LIST_CHANGE, 1);
        }
    }

    public int currentSize() {
        return this.tree.size(CURRENT_INDICES);
    }

    public int snapshotSize() {
        return this.tree.size(SNAPSHOT_INDICES);
    }

    public void reset(int size) {
        this.tree.clear();
        this.initialCapacityKnown = true;
        this.ensureCapacity(size);
    }

    private void ensureCapacity(int size) {
        int currentSize = this.tree.size(CURRENT_INDICES);
        int delta = size - currentSize;
        if (delta > 0) {
            int endOfTree = this.tree.size(ALL_INDICES);
            this.tree.add(endOfTree, ALL_INDICES, NO_CHANGE, LIST_CHANGE, delta);
        }
    }

    void addAll(BlockSequence blocks) {
        BlockSequence.Iterator i = blocks.iterator();
        while (i.nextBlock()) {
            int blockStart = i.getBlockStart();
            int blockEnd = i.getBlockEnd();
            int type = i.getType();
            if (type == 2) {
                this.insert(blockStart, blockEnd);
                continue;
            }
            if (type == 1) {
                this.update(blockStart, blockEnd);
                continue;
            }
            if (type == 0) {
                this.delete(blockStart, blockEnd);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    public boolean isEmpty() {
        return this.tree.size(CHANGE_INDICES) == 0;
    }

    public Iterator iterator() {
        return new Iterator(this.tree);
    }

    public String toString() {
        return this.tree.asSequenceOfColors();
    }

    public static class Iterator {
        private final FourColorTree tree;
        private final FourColorTreeIterator treeIterator;

        private Iterator(FourColorTree tree) {
            this.tree = tree;
            this.treeIterator = new FourColorTreeIterator(tree);
        }

        private Iterator(FourColorTree tree, FourColorTreeIterator treeIterator) {
            this.tree = tree;
            this.treeIterator = treeIterator;
        }

        public Iterator copy() {
            return new Iterator(this.tree, this.treeIterator.copy());
        }

        public int getIndex() {
            return this.treeIterator.index(CURRENT_INDICES);
        }

        public int getEndIndex() {
            return this.treeIterator.nodeStartIndex(CURRENT_INDICES) + this.treeIterator.nodeSize(ALL_INDICES);
        }

        public int getType() {
            byte color = this.treeIterator.color();
            if (color == INSERT) {
                return 2;
            }
            if (color == UPDATE) {
                return 1;
            }
            if (color == DELETE) {
                return 0;
            }
            throw new IllegalStateException();
        }

        public boolean next() {
            if (!this.hasNext()) {
                return false;
            }
            this.treeIterator.next(CHANGE_INDICES);
            return true;
        }

        public boolean nextNode() {
            if (!this.hasNextNode()) {
                return false;
            }
            this.treeIterator.nextNode(CHANGE_INDICES);
            return true;
        }

        public boolean hasNext() {
            return this.treeIterator.hasNext(CHANGE_INDICES);
        }

        public boolean hasNextNode() {
            return this.treeIterator.hasNextNode(CHANGE_INDICES);
        }
    }
}

