/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DecisionProbe;
import org.antlr.misc.BitSet;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarDanglingStateMessage;
import org.antlr.tool.GrammarNonDeterminismMessage;
import org.antlr.tool.GrammarSemanticsMessage;
import org.antlr.tool.LeftRecursionCyclesMessage;
import org.antlr.tool.Message;
import org.antlr.tool.RecursionOverflowMessage;

public class TestDFAConversion
extends BaseTest {
    public void testA() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A C | B;");
        String expecting = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testAB_or_AC() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A B | A C;");
        String expecting = ".s0-A->.s1\n.s1-B->:s3=>1\n.s1-C->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testselfRecurseNonDet() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : A a X | A a Y;");
        String expecting = ".s0-A->.s1\n.s1-A->:s2=>1\n";
        int[] unreachableAlts = new int[]{1, 2};
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = null;
        int[] danglingAlts = new int[]{1, 2};
        int numWarnings = 2;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testCannotSeePastRecursion() throws Exception {
        Grammar g = new Grammar("parser grammar t;\nx   : y X\n    | y Y\n    ;\ny   : L y R\n    | B\n    ;");
        String expecting = ".s0-B->.s6\n.s0-L->.s1\n.s1-B->.s3\n.s1-L->:s2=>1\n.s3-R->.s4\n.s4-X->:s2=>1\n.s4-Y->:s5=>2\n.s6-X->:s2=>1\n.s6-Y->:s5=>2\n";
        int[] unreachableAlts = new int[]{1, 2};
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = null;
        int[] danglingAlts = null;
        int numWarnings = 2;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testSynPredResolvesRecursion() throws Exception {
        Grammar g = new Grammar("parser grammar t;\nx   : (y X)=> y X\n    | y Y\n    ;\ny   : L y R\n    | B\n    ;");
        String expecting = ".s0-B->.s7\n.s0-L->.s1\n.s1-B->.s5\n.s1-L->.s2\n.s2-{synpred1}?->:s3=>1\n.s2-{true}?->:s4=>2\n.s5-R->.s6\n.s6-X->:s3=>1\n.s6-Y->:s4=>2\n.s7-X->:s3=>1\n.s7-Y->:s4=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = null;
        String ambigInput = null;
        int[] danglingAlts = null;
        int numWarnings = 0;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testSynPredResolvesRecursionInLexer() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA :     (B ';')=> B ';'\n  |     B '.'\n  ;\nfragment\nB :     '(' B ')'\n  |     'x'\n  ;\n");
        String expecting = ".s0-'('->.s1\n.s0-'x'->.s7\n.s1-'('->.s2\n.s1-'x'->.s5\n.s2-{synpred1}?->:s3=>1\n.s2-{true}?->:s4=>2\n.s5-')'->.s6\n.s6-'.'->:s4=>2\n.s6-';'->:s3=>1\n.s7-'.'->:s4=>2\n.s7-';'->:s3=>1\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = null;
        String ambigInput = null;
        int[] danglingAlts = null;
        int numWarnings = 0;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testAutoBacktrackResolvesRecursionInLexer() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\noptions {backtrack=true;}\nA :     B ';'\n  |     B '.'\n  ;\nfragment\nB :     '(' B ')'\n  |     'x'\n  ;\n");
        String expecting = ".s0-'('->.s1\n.s0-'x'->.s7\n.s1-'('->.s2\n.s1-'x'->.s5\n.s2-{synpred1}?->:s3=>1\n.s2-{true}?->:s4=>2\n.s5-')'->.s6\n.s6-'.'->:s4=>2\n.s6-';'->:s3=>1\n.s7-'.'->:s4=>2\n.s7-';'->:s3=>1\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = null;
        String ambigInput = null;
        int[] danglingAlts = null;
        int numWarnings = 0;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testAutoBacktrackResolvesRecursion() throws Exception {
        Grammar g = new Grammar("parser grammar t;\noptions {backtrack=true;}\nx   : y X\n    | y Y\n    ;\ny   : L y R\n    | B\n    ;");
        String expecting = ".s0-B->.s7\n.s0-L->.s1\n.s1-B->.s5\n.s1-L->.s2\n.s2-{synpred1}?->:s3=>1\n.s2-{true}?->:s4=>2\n.s5-R->.s6\n.s6-X->:s3=>1\n.s6-Y->:s4=>2\n.s7-X->:s3=>1\n.s7-Y->:s4=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = null;
        String ambigInput = null;
        int[] danglingAlts = null;
        int numWarnings = 0;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testselfRecurseNonDet2() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : P a P | P;");
        String expecting = ".s0-P->.s1\n.s1-EOF->:s2=>2\n.s1-P->:s3=>1\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "P P";
        int[] danglingAlts = null;
        int numWarnings = 1;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testIndirectRecursionLoop() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : b X ;\nb : a B ;\n");
        DecisionProbe.verbose = true;
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Set leftRecursive = g.getLeftRecursiveRules();
        HashSet expectedRules = new HashSet(){

            private final /* synthetic */ void this() {
                this.add("a");
                this.add("b");
            }
            {
                this.this();
            }
        };
        TestDFAConversion.assertEquals((Object)expectedRules, (Object)leftRecursive);
        g.createLookaheadDFAs();
        Message msg = (Message)equeue.warnings.get(0);
        TestDFAConversion.assertTrue((String)("expecting left recursion cycles; found " + msg.getClass().getName()), (boolean)(msg instanceof LeftRecursionCyclesMessage));
        LeftRecursionCyclesMessage cyclesMsg = (LeftRecursionCyclesMessage)msg;
        Collection result = cyclesMsg.cycles;
        ArrayList<2> expecting = new ArrayList<2>();
        expecting.add(new HashSet(){

            private final /* synthetic */ void this() {
                this.add("a");
                this.add("b");
            }
            {
                this.this();
            }
        });
        TestDFAConversion.assertEquals(expecting, (Object)result);
    }

    public void testIndirectRecursionLoop2() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : i b X ;\nb : a B ;\ni : ;\n");
        DecisionProbe.verbose = true;
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Set leftRecursive = g.getLeftRecursiveRules();
        HashSet expectedRules = new HashSet(){

            private final /* synthetic */ void this() {
                this.add("a");
                this.add("b");
            }
            {
                this.this();
            }
        };
        TestDFAConversion.assertEquals((Object)expectedRules, (Object)leftRecursive);
        g.createLookaheadDFAs();
        Message msg = (Message)equeue.warnings.get(0);
        TestDFAConversion.assertTrue((String)("expecting left recursion cycles; found " + msg.getClass().getName()), (boolean)(msg instanceof LeftRecursionCyclesMessage));
        LeftRecursionCyclesMessage cyclesMsg = (LeftRecursionCyclesMessage)msg;
        Collection result = cyclesMsg.cycles;
        ArrayList<4> expecting = new ArrayList<4>();
        expecting.add(new HashSet(){

            private final /* synthetic */ void this() {
                this.add("a");
                this.add("b");
            }
            {
                this.this();
            }
        });
        TestDFAConversion.assertEquals(expecting, (Object)result);
    }

    public void testIndirectRecursionLoop3() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : i b X ;\nb : a B ;\ni : ;\nd : e ;\ne : d ;\n");
        DecisionProbe.verbose = true;
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        Set leftRecursive = g.getLeftRecursiveRules();
        HashSet expectedRules = new HashSet(){

            private final /* synthetic */ void this() {
                this.add("a");
                this.add("b");
                this.add("e");
                this.add("d");
            }
            {
                this.this();
            }
        };
        TestDFAConversion.assertEquals((Object)expectedRules, (Object)leftRecursive);
        Message msg = (Message)equeue.warnings.get(0);
        TestDFAConversion.assertTrue((String)("expecting left recursion cycles; found " + msg.getClass().getName()), (boolean)(msg instanceof LeftRecursionCyclesMessage));
        LeftRecursionCyclesMessage cyclesMsg = (LeftRecursionCyclesMessage)msg;
        Collection result = cyclesMsg.cycles;
        ArrayList<HashSet> expecting = new ArrayList<HashSet>();
        expecting.add(new HashSet(){

            private final /* synthetic */ void this() {
                this.add("a");
                this.add("b");
            }
            {
                this.this();
            }
        });
        expecting.add(new HashSet(){

            private final /* synthetic */ void this() {
                this.add("d");
                this.add("e");
            }
            {
                this.this();
            }
        });
        TestDFAConversion.assertEquals(expecting, (Object)result);
    }

    public void testifThenElse() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : IF s (E s)? | B;\nslist: s SEMI ;");
        String expecting = ".s0-E->:s1=>1\n.s0-SEMI->:s2=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "E";
        int[] danglingAlts = null;
        int numWarnings = 1;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
        expecting = ".s0-B->:s2=>2\n.s0-IF->:s1=>1\n";
        this.checkDecision(g, 2, expecting, null, null, null, null, 0);
    }

    public void testifThenElseChecksStackSuffixConflict() throws Exception {
        Grammar g = new Grammar("parser grammar t;\nslist: s SEMI ;\ns : IF s el | B;\nel: (E s)? ;\n");
        String expecting = ".s0-E->:s1=>1\n.s0-SEMI->:s2=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "E";
        int[] danglingAlts = null;
        int numWarnings = 1;
        this.checkDecision(g, 2, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
        expecting = ".s0-B->:s2=>2\n.s0-IF->:s1=>1\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testInvokeRule() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : b A\n  | b B\n  | C\n  ;\nb : X\n  ;\n");
        String expecting = ".s0-C->:s4=>3\n.s0-X->.s1\n.s1-A->:s3=>1\n.s1-B->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testDoubleInvokeRuleLeftEdge() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : b X\n  | b Y\n  ;\nb : c B\n  | c\n  ;\nc : C ;\n");
        String expecting = ".s0-C->.s1\n.s1-B->.s4\n.s1-X->:s2=>1\n.s1-Y->:s3=>2\n.s4-X->:s2=>1\n.s4-Y->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
        expecting = ".s0-C->.s1\n.s1-B->:s3=>1\n.s1-X..Y->:s2=>2\n";
        this.checkDecision(g, 2, expecting, null, null, null, null, 0);
    }

    public void testimmediateTailRecursion() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : A a | A B;");
        String expecting = ".s0-A->.s1\n.s1-A->:s3=>1\n.s1-B->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testAStar_immediateTailRecursion() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : A a | ;");
        String expecting = ".s0-A->:s1=>1\n.s0-EOF->:s2=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = null;
        String ambigInput = null;
        int[] danglingAlts = null;
        int numWarnings = 0;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testNoStartRule() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A a | X;");
        DecisionProbe.verbose = true;
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        g.createNFAs();
        g.createLookaheadDFAs();
        Message msg = (Message)equeue.errors.get(0);
        TestDFAConversion.assertTrue((String)("expecting no start rules; found " + msg.getClass().getName()), (boolean)(msg instanceof GrammarSemanticsMessage));
    }

    public void testAStar_immediateTailRecursion2() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : A a | A ;");
        String expecting = ".s0-A->.s1\n.s1-A->:s3=>1\n.s1-EOF->:s2=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = null;
        String ambigInput = null;
        int[] danglingAlts = null;
        int numWarnings = 0;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testimmediateLeftRecursion() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : a A | B;");
        Set leftRecursive = g.getLeftRecursiveRules();
        HashSet expectedRules = new HashSet(){

            private final /* synthetic */ void this() {
                this.add("a");
            }
            {
                this.this();
            }
        };
        TestDFAConversion.assertEquals((Object)expectedRules, (Object)leftRecursive);
    }

    public void testIndirectLeftRecursion() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : b | A ;\nb : c ;\nc : a | C ;\n");
        Set leftRecursive = g.getLeftRecursiveRules();
        HashSet expectedRules = new HashSet(){

            private final /* synthetic */ void this() {
                this.add("a");
                this.add("b");
                this.add("c");
            }
            {
                this.this();
            }
        };
        TestDFAConversion.assertEquals((Object)expectedRules, (Object)leftRecursive);
    }

    public void testLeftRecursionInMultipleCycles() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a x ;\na : b | A ;\nb : c ;\nc : a | C ;\nx : y | X ;\ny : x ;\n");
        Set leftRecursive = g.getLeftRecursiveRules();
        HashSet expectedRules = new HashSet(){

            private final /* synthetic */ void this() {
                this.add("a");
                this.add("b");
                this.add("c");
                this.add("x");
                this.add("y");
            }
            {
                this.this();
            }
        };
        TestDFAConversion.assertEquals((Object)expectedRules, (Object)leftRecursive);
    }

    public void testCycleInsideRuleDoesNotForceInfiniteRecursion() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a ;\na : (A|)+ B;\n");
        Set leftRecursive = g.getLeftRecursiveRules();
        HashSet expectedRules = new HashSet();
        TestDFAConversion.assertEquals(expectedRules, (Object)leftRecursive);
    }

    public void testAStar() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : ( A )* ;");
        String expecting = ".s0-A->:s2=>1\n.s0-EOF->:s1=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testAorBorCStar() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : ( A | B | C )* ;");
        String expecting = ".s0-A..C->:s2=>1\n.s0-EOF->:s1=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testAPlus() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : ( A )+ ;");
        String expecting = ".s0-A->:s2=>1\n.s0-EOF->:s1=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testAPlusNonGreedyWhenDeterministic() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : (options {greedy=false;}:A)+ ;\n");
        String expecting = ".s0-A->:s2=>1\n.s0-EOF->:s1=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testAorBorCPlus() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : ( A | B | C )+ ;");
        String expecting = ".s0-A..C->:s2=>1\n.s0-EOF->:s1=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testAOptional() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : ( A )? B ;");
        String expecting = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testAorBorCOptional() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : ( A | B | C )? Z ;");
        String expecting = ".s0-A..C->:s1=>1\n.s0-Z->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testAStarBOrAStarC() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : (A)* B | (A)* C;");
        String expecting = ".s0-A->:s2=>1\n.s0-B->:s1=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
        expecting = ".s0-A->:s2=>1\n.s0-C->:s1=>2\n";
        this.checkDecision(g, 2, expecting, null, null, null, null, 0);
        expecting = ".s0-A->.s1\n.s0-B->:s2=>1\n.s0-C->:s3=>2\n.s1-A->.s1\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n";
        this.checkDecision(g, 3, expecting, null, null, null, null, 0);
    }

    public void testAStarBOrAPlusC() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : (A)* B | (A)+ C;");
        String expecting = ".s0-A->:s2=>1\n.s0-B->:s1=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
        expecting = ".s0-A->:s2=>1\n.s0-C->:s1=>2\n";
        this.checkDecision(g, 2, expecting, null, null, null, null, 0);
        expecting = ".s0-A->.s1\n.s0-B->:s2=>1\n.s1-A->.s1\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n";
        this.checkDecision(g, 3, expecting, null, null, null, null, 0);
    }

    public void testAOrBPlusOrAPlus() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : (A|B)* X | (A)+ Y;");
        String expecting = ".s0-A..B->:s2=>1\n.s0-X->:s1=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
        expecting = ".s0-A->:s2=>1\n.s0-Y->:s1=>2\n";
        this.checkDecision(g, 2, expecting, null, null, null, null, 0);
        expecting = ".s0-A->.s1\n.s0-B..X->:s2=>1\n.s1-A->.s1\n.s1-B..X->:s2=>1\n.s1-Y->:s3=>2\n";
        this.checkDecision(g, 3, expecting, null, null, null, null, 0);
    }

    public void testLoopbackAndExit() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : (A|B)+ B;");
        String expecting = ".s0-A->:s2=>1\n.s0-B->.s1\n.s1-A..B->:s2=>1\n.s1-EOF->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testOptionalAltAndBypass() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : (A|B)? B;");
        String expecting = ".s0-A->:s2=>1\n.s0-B->.s1\n.s1-B->:s2=>1\n.s1-EOF->:s3=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testResolveLL1ByChoosingFirst() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A C | A C;");
        String expecting = ".s0-A->.s1\n.s1-C->:s2=>1\n";
        int[] unreachableAlts = new int[]{2};
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "A C";
        int[] danglingAlts = null;
        int numWarnings = 2;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testResolveLL2ByChoosingFirst() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A B | A B;");
        String expecting = ".s0-A->.s1\n.s1-B->:s2=>1\n";
        int[] unreachableAlts = new int[]{2};
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "A B";
        int[] danglingAlts = null;
        int numWarnings = 2;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testResolveLL2MixAlt() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A B | A C | A B | Z;");
        String expecting = ".s0-A->.s1\n.s0-Z->:s4=>4\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n";
        int[] unreachableAlts = new int[]{3};
        int[] nonDetAlts = new int[]{1, 3};
        String ambigInput = "A B";
        int[] danglingAlts = null;
        int numWarnings = 2;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testIndirectIFThenElseStyleAmbig() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : stat ;\nstat : LCURLY ( cg )* RCURLY | E SEMI  ;\ncg : (c)+ (stat)* ;\nc : CASE E ;\n");
        String expecting = ".s0-CASE->:s2=>1\n.s0-LCURLY..E->:s1=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "CASE";
        int[] danglingAlts = null;
        int numWarnings = 1;
        this.checkDecision(g, 3, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testComplement() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : ~(A | B | C) | C;\nb : X Y Z ;");
        String expecting = ".s0-C->:s2=>2\n.s0-X..Z->:s1=>1\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testComplementToken() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : ~C | C;\nb : X Y Z ;");
        String expecting = ".s0-C->:s2=>2\n.s0-X..Z->:s1=>1\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testComplementChar() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : ~'x' | 'x';\n");
        String expecting = ".s0-'x'->:s2=>2\n.s0-{'\\u0000'..'w', 'y'..'\\uFFFE'}->:s1=>1\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testComplementCharSet() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : ~(' '|'\t'|'x') | 'x';\n");
        String expecting = ".s0-'x'->:s2=>2\n.s0-{'\\u0000'..'\\b', '\\n'..'\\u001F', '!'..'w', 'y'..'\\uFFFE'}->:s1=>1\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testNoSetCollapseWithActions() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : (A | B {foo}) | C;");
        String expecting = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testRuleAltsSetCollapse() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A | B | C ;");
        String expecting = " ( grammar t ( rule a ARG RET scope ( BLOCK ( ALT ( SET A B C ) <end-of-alt> ) <end-of-block> ) <end-of-rule> ) )";
        TestDFAConversion.assertEquals((String)expecting, (String)g.getGrammarTree().toStringTree());
    }

    public void testTokensRuleAltsDoNotCollapse() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';B : 'b';\n");
        String expecting = ".s0-'a'->:s1=>1\n.s0-'b'->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testMultipleSequenceCollision() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : (A{;}|B)\n  | (A{;}|B)\n  | A\n  ;");
        String expecting = ".s0-A->:s1=>1\n.s0-B->:s2=>1\n";
        int[] unreachableAlts = new int[]{2, 3};
        int[] nonDetAlts = new int[]{1, 2, 3};
        String ambigInput = "A";
        int[] danglingAlts = null;
        int numWarnings = 3;
        this.checkDecision(g, 3, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testMultipleAltsSameSequenceCollision() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : type ID \n  | type ID\n  | type ID\n  | type ID\n  ;\n\ntype : I | F;");
        String expecting = ".s0-I..F->.s1\n.s1-ID->:s2=>1\n";
        int[] unreachableAlts = new int[]{2, 3, 4};
        int[] nonDetAlts = new int[]{1, 2, 3, 4};
        String ambigInput = "I..F ID";
        int[] danglingAlts = null;
        int numWarnings = 2;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testFollowReturnsToLoopReenteringSameRule() throws Exception {
        Grammar g = new Grammar("parser grammar t;\nsl : L ( esc | ~(R|SLASH) )* R ;\n\nesc : SLASH ( N | D03 (D07)? ) ;");
        String expecting = ".s0-R->:s1=>3\n.s0-SLASH->:s2=>1\n.s0-{L, N..D07}->:s3=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "D07";
        int[] danglingAlts = null;
        int numWarnings = 1;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testTokenCallsAnotherOnLeftEdge() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nF   :   I '.'\n    ;\nI   :   '0'\n    ;\n");
        String expecting = ".s0-'0'->.s1\n.s1-'.'->:s3=>1\n.s1-<EOT>->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testSelfRecursionAmbigAlts() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : a;\na   :   L ID R\n    |   L a R\n    |   b\n    ;\n\nb   :   ID\n    ;\n");
        String expecting = ".s0-ID->:s5=>3\n.s0-L->.s1\n.s1-ID->.s2\n.s1-L->:s4=>2\n.s2-R->:s3=>1\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "L ID R";
        int[] danglingAlts = null;
        int numWarnings = 1;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testIndirectRecursionAmbigAlts() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns   :   a ;\na   :   L ID R\n    |   b\n    ;\n\nb   :   ID\n    |   L a R\n    ;");
        String expecting = ".s0-ID->:s4=>2\n.s0-L->.s1\n.s1-ID->.s2\n.s1-L->:s4=>2\n.s2-R->:s3=>1\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "L ID R";
        int[] danglingAlts = null;
        int numWarnings = 1;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testTailRecursionInvokedFromArbitraryLookaheadDecision() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : b X\n  | b Y\n  ;\n\nb : A\n  | A b\n  ;\n");
        String expecting = ".s0-A->.s1\n.s1-Y->:s3=>2\n.s1-{X, A}->:s2=>1\n";
        int[] unreachableAlts = new int[]{1, 2};
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = null;
        int[] danglingAlts = null;
        int numWarnings = 2;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testNoSetForTokenRefsInLexer() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : (B | C) ;\nfragment B : 'b' ;\nfragment C : 'c' ;\n");
        String expecting = ".s0-'b'->:s1=>1\n.s0-'c'->:s2=>2\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    public void testWildcardStarK1AndNonGreedyByDefaultInParser() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : A block B+ EOF ;\nblock : L .* R ;");
        String expecting = ".s0-B->:s2=>1\n.s0-EOF->:s1=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "R";
        int[] danglingAlts = null;
        int numWarnings = 1;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testWildcardPlusK1AndNonGreedyByDefaultInParser() throws Exception {
        Grammar g = new Grammar("parser grammar t;\ns : A block B+ EOF ;\nblock : L .+ R ;");
        String expecting = ".s0-B->:s2=>1\n.s0-EOF->:s1=>2\n";
        int[] unreachableAlts = null;
        int[] nonDetAlts = new int[]{1, 2};
        String ambigInput = "R";
        int[] danglingAlts = null;
        int numWarnings = 1;
        this.checkDecision(g, 1, expecting, unreachableAlts, nonDetAlts, ambigInput, danglingAlts, numWarnings);
    }

    public void testCyclicTableCreation() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A+ X | A+ Y ;");
        String expecting = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
    }

    public void _template() throws Exception {
        Grammar g = new Grammar("parser grammar t;\na : A | B;");
        String expecting = "\n";
        this.checkDecision(g, 1, expecting, null, null, null, null, 0);
    }

    protected void checkDecision(Grammar g, int decision, String expecting, int[] expectingUnreachableAlts, int[] expectingNonDetAlts, String expectingAmbigInput, int[] expectingDanglingAlts, int expectingNumWarnings) throws Exception {
        GrammarNonDeterminismMessage nondetMsg;
        DecisionProbe.verbose = true;
        ErrorQueue equeue = new ErrorQueue();
        ErrorManager.setErrorListener(equeue);
        if (g.getNumberOfDecisions() == 0) {
            g.createNFAs();
            g.createLookaheadDFAs();
        }
        if (equeue.size() != expectingNumWarnings) {
            System.err.println("Warnings issued: " + equeue);
        }
        TestDFAConversion.assertEquals((String)"unexpected number of expected problems", (int)expectingNumWarnings, (int)equeue.size());
        DFA dfa = g.getLookaheadDFA(decision);
        TestDFAConversion.assertNotNull((String)("no DFA for decision " + decision), (Object)dfa);
        FASerializer serializer = new FASerializer(g);
        String result = serializer.serialize(dfa.startState);
        List unreachableAlts = dfa.getUnreachableAlts();
        if (expectingUnreachableAlts != null) {
            BitSet s = new BitSet();
            s.addAll(expectingUnreachableAlts);
            BitSet s2 = new BitSet();
            s2.addAll(unreachableAlts);
            TestDFAConversion.assertEquals((String)"unreachable alts mismatch", (Object)s, (Object)s2);
        } else {
            TestDFAConversion.assertEquals((String)"number of unreachable alts", (int)0, (int)unreachableAlts.size());
        }
        if (expectingAmbigInput != null) {
            Message msg = (Message)equeue.warnings.get(0);
            TestDFAConversion.assertTrue((String)("expecting nondeterminism; found " + msg.getClass().getName()), (boolean)(msg instanceof GrammarNonDeterminismMessage));
            nondetMsg = this.getNonDeterminismMessage(equeue.warnings);
            List labels = nondetMsg.probe.getSampleNonDeterministicInputSequence(nondetMsg.problemState);
            String input = nondetMsg.probe.getInputSequenceDisplay(labels);
            TestDFAConversion.assertEquals((String)expectingAmbigInput, (String)input);
        }
        if (expectingNonDetAlts != null) {
            RecursionOverflowMessage recMsg = null;
            nondetMsg = this.getNonDeterminismMessage(equeue.warnings);
            List nonDetAlts = null;
            if (nondetMsg != null) {
                nonDetAlts = nondetMsg.probe.getNonDeterministicAltsForState(nondetMsg.problemState);
            } else {
                recMsg = this.getRecursionOverflowMessage(equeue.warnings);
            }
            BitSet s = new BitSet();
            s.addAll(expectingNonDetAlts);
            BitSet s2 = new BitSet();
            s2.addAll(nonDetAlts);
            TestDFAConversion.assertEquals((String)"nondet alts mismatch", (Object)s, (Object)s2);
            String string = "found no nondet alts; expecting: " + this.str(expectingNonDetAlts);
            boolean bl = false;
            if (nondetMsg != null || recMsg != null) {
                bl = true;
            }
            TestDFAConversion.assertTrue((String)string, (boolean)bl);
        } else {
            GrammarNonDeterminismMessage nondetMsg2 = this.getNonDeterminismMessage(equeue.warnings);
            TestDFAConversion.assertNull((String)"found nondet alts, but expecting none", (Object)nondetMsg2);
        }
        TestDFAConversion.assertEquals((String)expecting, (String)result);
    }

    protected GrammarNonDeterminismMessage getNonDeterminismMessage(List warnings) {
        int i = 0;
        while (i < warnings.size()) {
            Message m = (Message)warnings.get(i);
            if (m instanceof GrammarNonDeterminismMessage) {
                return (GrammarNonDeterminismMessage)m;
            }
            ++i;
        }
        return null;
    }

    protected RecursionOverflowMessage getRecursionOverflowMessage(List warnings) {
        int i = 0;
        while (i < warnings.size()) {
            Message m = (Message)warnings.get(i);
            if (m instanceof RecursionOverflowMessage) {
                return (RecursionOverflowMessage)m;
            }
            ++i;
        }
        return null;
    }

    protected LeftRecursionCyclesMessage getLeftRecursionCyclesMessage(List warnings) {
        int i = 0;
        while (i < warnings.size()) {
            Message m = (Message)warnings.get(i);
            if (m instanceof LeftRecursionCyclesMessage) {
                return (LeftRecursionCyclesMessage)m;
            }
            ++i;
        }
        return null;
    }

    protected GrammarDanglingStateMessage getDanglingStateMessage(List warnings) {
        int i = 0;
        while (i < warnings.size()) {
            Message m = (Message)warnings.get(i);
            if (m instanceof GrammarDanglingStateMessage) {
                return (GrammarDanglingStateMessage)m;
            }
            ++i;
        }
        return null;
    }

    protected String str(int[] elements) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            if (i > 0) {
                buf.append(", ");
            }
            int element = elements[i];
            buf.append(element);
            ++i;
        }
        return buf.toString();
    }
}

