/*
 $Id: MethodTest.java,v 1.5 2003/11/20 11:32:04 jstrachan Exp $

 Copyright 2003 (C) James Strachan and Bob Mcwhirter. All Rights Reserved.

 Redistribution and use of this software and associated documentation
 ("Software"), with or without modification, are permitted provided
 that the following conditions are met:

 1. Redistributions of source code must retain copyright
    statements and notices.  Redistributions must also contain a
    copy of this document.

 2. Redistributions in binary form must reproduce the
    above copyright notice, this list of conditions and the
    following disclaimer in the documentation and/or other
    materials provided with the distribution.

 3. The name "groovy" must not be used to endorse or promote
    products derived from this Software without prior written
    permission of The Codehaus.  For written permission,
    please contact info@codehaus.org.

 4. Products derived from this Software may not be called "groovy"
    nor may "groovy" appear in their names without prior written
    permission of The Codehaus. "groovy" is a registered
    trademark of The Codehaus.

 5. Due credit should be given to The Codehaus -
    http://groovy.codehaus.org/

 THIS SOFTWARE IS PROVIDED BY THE CODEHAUS AND CONTRIBUTORS
 ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
 NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 THE CODEHAUS OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

 */

package org.codehaus.groovy.classgen;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.runtime.InvokerHelper;

/**
 * 
 * @author <a href="mailto:james@coredevelopers.net">James Strachan</a>
 * @version $Revision: 1.5 $
 */
public class MethodTest extends TestSupport {

    public void testMethods() throws Exception {
        ClassNode classNode = new ClassNode("Foo", ACC_PUBLIC, "java.lang.Object");
        classNode.addConstructor(new ConstructorNode(ACC_PUBLIC, null));

        Statement statementA = new ReturnStatement(new ConstantExpression("calledA"));
        Statement statementB = new ReturnStatement(new ConstantExpression("calledB"));
        Statement emptyStatement = new BlockStatement();

        classNode.addMethod(new MethodNode("a", ACC_PUBLIC, "java.lang.Object", Parameter.EMPTY_ARRAY, statementA));
        classNode.addMethod(new MethodNode("b", ACC_PUBLIC, null, Parameter.EMPTY_ARRAY, statementB));
        
        classNode.addMethod(new MethodNode("noReturnMethodA", ACC_PUBLIC, null, Parameter.EMPTY_ARRAY, emptyStatement));
        classNode.addMethod(new MethodNode("noReturnMethodB", ACC_PUBLIC, "java.lang.Object", Parameter.EMPTY_ARRAY, emptyStatement));
        
        classNode.addMethod(new MethodNode("c", ACC_PUBLIC, "void", Parameter.EMPTY_ARRAY, emptyStatement));

        Class fooClass = loadClass(classNode);
        assertTrue("Loaded a new class", fooClass != null);

        Object bean = fooClass.newInstance();
        assertTrue("Created instance of class: " + bean, bean != null);
 
        assertCallMethod(bean, "a", "calledA");
        assertCallMethod(bean, "b", "calledB");
        assertCallMethod(bean, "noReturnMethodA", null);
        assertCallMethod(bean, "noReturnMethodB", null);
        assertCallMethod(bean, "c", null);
    }

    protected void assertCallMethod(Object object, String method, Object expected) {
        Object value = InvokerHelper.invokeMethod(object, method, new Object[0]);
        assertEquals("Result of calling method: " + method + " on: " + object + " with empty list", expected, value);

        value = InvokerHelper.invokeMethod(object, method, null);
        assertEquals("Result of calling method: " + method + " on: " + object + " with null", expected, value);
    }
}
