/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / ISO Media File Format sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <gpac/intern/m4_isomedia_dev.h>

void stbl_AppendTime(SampleTableAtom *stbl, u32 duration)
{
	sttsEntry *ent;
	u32 count;
	count = ChainGetCount(stbl->TimeToSample->entryList);
	if (count) {
		ent = ChainGetEntry(stbl->TimeToSample->entryList, count-1);
		if (ent->sampleDelta == duration) {
			ent->sampleCount += 1;
			return;
		}
	}
	//nope need a new entry
	ent = malloc(sizeof(sttsEntry));
	ent->sampleCount = 1;
	ent->sampleDelta = duration;
	ChainAddEntry(stbl->TimeToSample->entryList, ent);
}

void stbl_AppendSize(SampleTableAtom *stbl, u32 size)
{
	u32 *new_sizes, i;

	if (!stbl->SampleSize->sampleCount) {
		stbl->SampleSize->sampleSize = size;
		stbl->SampleSize->sampleCount = 1;
		return;
	}
	if (stbl->SampleSize->sampleSize && (stbl->SampleSize->sampleSize==size)) {
		stbl->SampleSize->sampleCount += 1;
		return;
	}
	//realloc
	new_sizes = malloc(sizeof(u32)*(stbl->SampleSize->sampleCount+1));
	if (stbl->SampleSize->sizes) {
		memcpy(new_sizes, stbl->SampleSize->sizes, sizeof(u32)*stbl->SampleSize->sampleCount);
		free(stbl->SampleSize->sizes);
	} else {
		for (i=0; i<stbl->SampleSize->sampleCount;i++) new_sizes[i] = stbl->SampleSize->sampleSize;
	}
	stbl->SampleSize->sampleSize = 0;
	new_sizes[stbl->SampleSize->sampleCount] = size;
	stbl->SampleSize->sampleCount += 1;
	stbl->SampleSize->sizes = new_sizes;
}

void stbl_AppendChunk(SampleTableAtom *stbl, u64 offset)
{
	ChunkOffsetAtom *stco;
	ChunkLargeOffsetAtom *co64;
	u32 *new_offsets, i;
	u64 *off_64;

	//we may have to convert the table...
	if (stbl->ChunkOffset->type==ChunkOffsetAtomType) {
		stco = (ChunkOffsetAtom *)stbl->ChunkOffset;

		if (offset>0xFFFFFFFF) {
			co64 = (ChunkLargeOffsetAtom *) CreateAtom(ChunkLargeOffsetAtomType);
			co64->entryCount = stco->entryCount + 1;
			co64->offsets = (u64*)malloc(sizeof(u64) * co64->entryCount);
			for (i=0; i<stco->entryCount; i++) co64->offsets[i] = stco->offsets[i];
			co64->offsets[i] = offset;
			DelAtom(stbl->ChunkOffset);
			stbl->ChunkOffset = (Atom *) co64;
			return;
		}
		//we're fine
		new_offsets = malloc(sizeof(u32)*(stco->entryCount+1));
		for (i=0; i<stco->entryCount; i++) new_offsets[i] = stco->offsets[i];
		new_offsets[i] = (u32) offset;
		if (stco->offsets) free(stco->offsets);
		stco->offsets = new_offsets;
		stco->entryCount += 1;
	}
	//large offsets
	else {
		co64 = (ChunkLargeOffsetAtom *)stbl->ChunkOffset;
		off_64 = malloc(sizeof(u32)*(co64->entryCount+1));
		for (i=0; i<co64->entryCount; i++) off_64[i] = co64->offsets[i];
		off_64[i] = offset;
		if (co64->offsets) free(co64->offsets);
		co64->offsets = off_64;
		co64->entryCount += 1;
	}
}

void stbl_AppendSampleToChunk(SampleTableAtom *stbl, u32 DescIndex, u32 samplesInChunk)
{
	u32 count, nextChunk;
	stscEntry *ent;

	count = ChainGetCount(stbl->SampleToChunk->entryList);
	nextChunk = ((ChunkOffsetAtom *) stbl->ChunkOffset)->entryCount;

	if (count) {
		ent = ChainGetEntry(stbl->SampleToChunk->entryList, count-1);
		//good we can use this one
		if ( (ent->sampleDescriptionIndex == DescIndex) && (ent->samplesPerChunk==samplesInChunk)) 
			return;

		//set the next chunk btw ...
		ent->nextChunk = nextChunk;
	}
	//ok we need a new entry - this assumes this function is called AFTER AppendChunk
	ent = malloc(sizeof(stscEntry));
	ent->firstChunk = nextChunk;
	ent->nextChunk = 0;
	ent->isEdited = 0;
	ent->sampleDescriptionIndex = DescIndex;
	ent->samplesPerChunk = samplesInChunk;
	ChainAddEntry(stbl->SampleToChunk->entryList, ent);
}

//called AFTER AddSize
void stbl_AppendRAP(SampleTableAtom *stbl, u8 isRap)
{
	u32 *new_raps, i;

	//no sync table
	if (!stbl->SyncSample) {
		//all samples RAP - no table
		if (isRap) return;

		//nope, create one
		stbl->SyncSample = (SyncSampleAtom *) CreateAtom(SyncSampleAtomType);
		if (stbl->SampleSize->sampleCount > 1) {
			stbl->SyncSample->sampleNumbers = malloc(sizeof(u32) * (stbl->SampleSize->sampleCount-1));
			for (i=0; i<stbl->SampleSize->sampleCount-1; i++) 
				stbl->SyncSample->sampleNumbers[i] = i+1;

		}
		stbl->SyncSample->entryCount = stbl->SampleSize->sampleCount-1;
		return;
	}
	if (!isRap) return;

	new_raps = malloc(sizeof(u32) * (stbl->SyncSample->entryCount + 1));
	for (i=0; i<stbl->SyncSample->entryCount; i++) new_raps[i] = stbl->SyncSample->sampleNumbers[i];
	new_raps[i] = stbl->SampleSize->sampleCount;
	if (stbl->SyncSample->sampleNumbers) free(stbl->SyncSample->sampleNumbers);
	stbl->SyncSample->sampleNumbers = new_raps;
	stbl->SyncSample->entryCount += 1;
}

void stbl_AppendPadding(SampleTableAtom *stbl, u8 padding)
{
	u32 i;
	u8 *pad_bits;
	if (!stbl->PaddingBits) stbl->PaddingBits = (PaddingBitsAtom *) CreateAtom(PaddingBitsAtomType);

	pad_bits = malloc(sizeof(u8) * stbl->SampleSize->sampleCount);
	memset(pad_bits, 0, sizeof(pad_bits));
//	for (i=0; i<stbl->SampleSize->sampleCount; i++) pad_bits[i] = 0;
	for (i=0; i<stbl->PaddingBits->SampleCount; i++) pad_bits[i] = stbl->PaddingBits->padbits[i];
	pad_bits[stbl->SampleSize->sampleCount-1] = padding;
	if (stbl->PaddingBits->padbits) free(stbl->PaddingBits->padbits);
	stbl->PaddingBits->padbits = pad_bits;
	stbl->PaddingBits->SampleCount = stbl->SampleSize->sampleCount;
}

void stbl_AppendCTSOffset(SampleTableAtom *stbl, u32 CTSOffset)
{
	u32 count;
	dttsEntry *ent;

	if (!stbl->CompositionOffset) stbl->CompositionOffset = (CompositionOffsetAtom *) CreateAtom(CompositionOffsetAtomType);

	count = ChainGetCount(stbl->CompositionOffset->entryList);
	if (count) {
		ent = ChainGetEntry(stbl->CompositionOffset->entryList, count-1);
		if (ent->decodingOffset == CTSOffset) {
			ent->sampleCount ++;
			return;
		}
	}
	ent = malloc(sizeof(dttsEntry));
	ent->sampleCount = 1;
	ent->decodingOffset = CTSOffset;
	ChainAddEntry(stbl->CompositionOffset->entryList, ent);
}

void stbl_AppendDegradation(SampleTableAtom *stbl, u16 DegradationPriority)
{
	u32 i;
	u16 *prio;
	if (!stbl->DegradationPriority) stbl->DegradationPriority = (DegradationPriorityAtom *) CreateAtom(DegradationPriorityAtomType);

	prio = malloc(sizeof(u16) * stbl->SampleSize->sampleCount);
	memset(prio, 0, sizeof(prio));
	for (i=0; i<stbl->DegradationPriority->entryCount; i++) prio[i] = stbl->DegradationPriority->priorities[i];
	prio[stbl->SampleSize->sampleCount-1] = DegradationPriority;
	if (stbl->DegradationPriority->priorities) free(stbl->DegradationPriority->priorities);
	stbl->DegradationPriority->priorities = prio;
	stbl->DegradationPriority->entryCount = stbl->SampleSize->sampleCount;
}


