#include "safe_include.h" 
#include <gpac/m4_terminal.h>

#include "wx/wxprec.h"

#ifndef WX_PRECOMP
  #include "wx/wx.h"
#endif

#include "wxGPACPanel.h"
#include "V4StudioFrame.h"


wxGPACPanel::wxGPACPanel(V4StudioFrame *v4sf) 
{
	m_pV4sf = v4sf;
	GPACInit();			
	m_iDragging = 0;
	m_transformMode = 0;
	dragX = dragY = 0;
	picked = NULL;
}

wxGPACPanel::~wxGPACPanel()
{
	if (m_pSr) {
		SR_SetSceneGraph(m_pSr, NULL);
		SR_Delete(m_pSr);

		PM_Delete(m_Client.plugins);
		IF_Delete(m_Client.config);
	}
}


Bool V4S_EventProc(void *par, M4Event *evt)
{
	wxGPACPanel *panel = (wxGPACPanel *)par;

	switch (evt->type) {
	case M4E_REFRESH:
		SR_RefreshWindow(panel->m_pSr);
		break;
	case M4E_WINDOWSIZE:
		SR_SizeChanged(panel->m_pSr, evt->size.width, evt->size.height);
		panel->Update();
		break;
	case M4E_LEFTDOWN:
		panel->picked = SR_PickNode(panel->m_pSr, evt->mouse.x, evt->mouse.y);
		panel->m_iDragging ++;
		if (panel->picked) {
			panel->m_pV4sf->GetTreeView()->SetSelectedItem(panel->picked);	
			panel->dragX = evt->mouse.x;
			panel->dragY = evt->mouse.y;
			panel->m_transformMode = 0;
		}
		break;
	case M4E_LEFTUP:
		panel->m_iDragging --;
		if (panel->picked) {
			int dX = evt->mouse.x - panel->dragX;
			int dY = evt->mouse.y - panel->dragY;
			panel->dragX = evt->mouse.x;
			panel->dragY = evt->mouse.y;
			wxString pos;
			pos << dX;
			pos << ',';
			pos << dY;
			panel->m_pV4sf->GetTreeView()->Translate(dX,dY);
			panel->m_pV4sf->GetStatusBar()->SetStatusText(pos);
		}
		break;
	case M4E_RIGHTDOWN:
		panel->m_iDragging ++;
		panel->picked = SR_PickNode(panel->m_pSr, evt->mouse.x, evt->mouse.y);
		if (panel->picked) {
			panel->m_pV4sf->GetTreeView()->SetSelectedItem(panel->picked);	
			panel->dragX = evt->mouse.x;
			panel->dragY = evt->mouse.y;
			panel->m_transformMode = 1;
		}
		break;
	case M4E_RIGHTUP:
		panel->m_iDragging --;
		if (panel->picked) {
			int dX = evt->mouse.x - panel->dragX;
			int dY = evt->mouse.y - panel->dragY;
			panel->dragX = evt->mouse.x;
			panel->dragY = evt->mouse.y;
			wxString pos;
			pos << dX;
			pos << ',';
			pos << dY;
			panel->m_pV4sf->GetTreeView()->Scale(dX,dY);
			panel->m_pV4sf->GetStatusBar()->SetStatusText(pos);
		}
		break;
	case M4E_MIDDLEDOWN:
		panel->m_iDragging ++;
		panel->picked = SR_PickNode(panel->m_pSr, evt->mouse.x, evt->mouse.y);
		if (panel->picked) {
			panel->m_pV4sf->GetTreeView()->SetSelectedItem(panel->picked);	
			panel->dragX = evt->mouse.x;
			panel->dragY = evt->mouse.y;
			panel->m_transformMode = 2;
		}
		break;
	case M4E_MIDDLEUP:
		panel->m_iDragging --;
		if (panel->picked) {
			int dX = evt->mouse.x - panel->dragX;
			int dY = evt->mouse.y - panel->dragY;
			panel->dragX = evt->mouse.x;
			panel->dragY = evt->mouse.y;
			wxString pos;
			pos << dX;
			pos << ',';
			pos << dY;
			panel->m_pV4sf->GetTreeView()->Rotate(dX,dY);
			panel->m_pV4sf->GetStatusBar()->SetStatusText(pos);
		}
		break;
	case M4E_MOUSEMOVE:
	{
		wxString pos;
		if (panel->picked && panel->m_iDragging) {
			int dX = evt->mouse.x - panel->dragX;
			int dY = evt->mouse.y - panel->dragY;
			panel->dragX = evt->mouse.x;
			panel->dragY = evt->mouse.y;
			pos << dX;
			pos << ',';
			pos << dY;
			switch (panel->m_transformMode) {
			case 0:
				panel->m_pV4sf->GetTreeView()->Translate(dX,dY);
				break;
			case 1:
				panel->m_pV4sf->GetTreeView()->Scale(dX,dY);
				break;
			case 2:			
				panel->m_pV4sf->GetTreeView()->Rotate(dX,dY);
				break;
			}
		} else {
			pos << evt->mouse.x;
			pos << ',';
			pos << evt->mouse.y;
		}
		panel->m_pV4sf->GetStatusBar()->SetStatusText(pos);
	}
		break;
	case M4E_QUIT:
		panel->m_pV4sf->Close(TRUE);
		break;
	}
	return 0;
}

void wxGPACPanel::SetSize(u32 width, u32 height)
{
}

void wxGPACPanel::Update() 
{
	SR_Invalidate(m_pSr, NULL);
	SR_RenderFrame(m_pSr);
}

bool wxGPACPanel::GPACInit() 
{
	char config_path[MAX_FILE_PATH];

#if defined(_WIN32) || defined(WIN32)
#ifdef _DEBUG
	strcpy(config_path, "D:\\CVS\\gpac\\bin\\debug");
#else
	strcpy(config_path, "C:\\Program Files\\GPAC");
#endif
#else
	char *cfg_dir = getenv("HOME");
	if (cfg_dir) {
		strcpy(config_path, cfg_dir);
	} else {
		fprintf(stdout, "WARNING: HOME env var not set - using current directory for config file\n");
		strcpy(config_path, ".");
	}
	fprintf(stdout, "looking for config file in %s\n", config_path);
#endif
	
	memset(&m_Client, 0, sizeof(M4User));
	m_Client.config = NewIniFile(config_path, "GPAC.cfg");
	while (!m_Client.config) {
		wxFileDialog *dlg = new wxFileDialog(m_pV4sf, "Please locate the GPAC Configuration File"
				,"", "", "CFG Files (*.cfg)|*.cfg|All files (*.*)|*.*", wxOPEN, wxDefaultPosition);
		if ( dlg->ShowModal() == wxID_OK ) { 
			m_Client.config = NewIniFile(dlg->GetDirectory(), dlg->GetFilename());
		} else {
			dlg->Destroy();
			return false;
		}
		dlg->Destroy();
	}
	char *test = IF_GetKey(m_Client.config, "General", "PluginsDirectory");
	m_Client.plugins = NewPluginManager((const unsigned char *) test, m_Client.config);
	if (!PM_GetPluginsCount(m_Client.plugins)) {
		// TODO: create a message Box to locate the directory where .cfg is stored
		return false;
	}

	m_Client.EventProc = V4S_EventProc;
	m_Client.os_window_handler = NULL;
	m_Client.opaque = this;

	m_pSr = NewSceneRender(&m_Client, 0, 1, NULL);

	SR_SetOption(m_pSr, M4O_DirectRender, 0);
	/*we do everything*/
	SR_SetOption(m_pSr, M4O_InteractLevel, 0);
	/*load config*/
	SR_SetOption(m_pSr, M4O_ReloadConfig, 1);
	return true;
}

