// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__3666B63B_D886_4F0B_9953_A2AF09E3C15A__INCLUDED_)
#define AFX_MAINFRM_H__3666B63B_D886_4F0B_9953_A2AF09E3C15A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ChildView.h"
#include <gpac/m4_tools.h>
#include "ProgressBar.h"
#include "FileProps.h"
#include "Options.h"

class CMainFrame : public CFrameWnd
{
	
public:
	CMainFrame();
protected: 
	DECLARE_DYNAMIC(CMainFrame)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	virtual BOOL DestroyWindow();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

public:  
	CStatusBar  m_wndStatusBar;
	ProgressBar    m_progBar;
	CFileProps *m_pProps;
	COptions *m_pOpt;
	CChildView *m_pWndView;

	Bool m_bShowControl;
	Bool m_bFullScreen;

public:
	void SetSize(UINT width, UINT height);
	void SetFullscreen();
	u32 m_timer_on;
	CString console_message;
	M4Err console_err;

	u32 m_aspect_ratio;
	RECT backup_wnd_rc;
private:
	void ForwardMessage();
	HICON m_icoerror, m_icomessage;

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSetFocus(CWnd *pOldWnd);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMove(int x, int y);
	afx_msg LONG OnSetSize(WPARAM wParam, LPARAM lParam);
	afx_msg LONG OnNavigate(WPARAM wParam, LPARAM lParam);
	afx_msg LONG Open(WPARAM wParam, LPARAM lParam);
	afx_msg LONG Stop(WPARAM wParam, LPARAM lParam);
	afx_msg LONG SetTiming(WPARAM wParam, LPARAM lParam);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnChar( UINT nChar, UINT nRepCnt, UINT nFlags );
	afx_msg void OnSysKeyDown( UINT nChar, UINT nRepCnt, UINT nFlags );
	afx_msg void OnSysKeyUp( UINT nChar, UINT nRepCnt, UINT nFlags );
	afx_msg void OnKeyDown( UINT nChar, UINT nRepCnt, UINT nFlags );
	afx_msg void OnKeyUp( UINT nChar, UINT nRepCnt, UINT nFlags );
	afx_msg void OnDropFiles(HDROP hDropInfo);
	afx_msg void OnViewControl();
	afx_msg LONG OnConsoleMessage(WPARAM wParam, LPARAM lParam);
	afx_msg void OnUpdateViewControl(CCmdUI* pCmdUI);
	afx_msg void OnViewOriginal();
	afx_msg void OnViewFullscreen();
	afx_msg void OnArKeep();
	afx_msg void OnArFill();
	afx_msg void OnAr43();
	afx_msg void OnAr169();
	afx_msg void OnUpdateAr169(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAr43(CCmdUI* pCmdUI);
	afx_msg void OnUpdateArFill(CCmdUI* pCmdUI);
	afx_msg void OnUpdateArKeep(CCmdUI* pCmdUI);
	afx_msg void OnShortcuts();
	afx_msg void OnConfigure();
	afx_msg void OnFileProp();
	afx_msg void OnUpdateFileProp(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__3666B63B_D886_4F0B_9953_A2AF09E3C15A__INCLUDED_)
