static char rcsid[] = "$Id: b42c1201e488345321bb819fc31108c3dae3e699 $";
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "dinucl_bits.h"

/* Perl code for generating these arrays */

/*
#! /usr/bin/env perl

use warnings;

use Getopt::Std;
getopts("t:9");

#if (defined($opt_9)) {
#    $mers = make_mer(8);
#}


$col = 0;

if ($opt_t eq "donor_gtgc") {
    print "const Genomecomp_T donor_gtgc_bits[] =\n";

} elsif ($opt_t eq "acceptor_ag") {
    print "const Genomecomp_T acceptor_ag_bits[] =\n";
    
} elsif ($opt_t eq "donor_at") {
    print "const Genomecomp_T donor_at_bits[] =\n";

} elsif ($opt_t eq "acceptor_ac") {
    print "const Genomecomp_T acceptor_ac_bits[] =\n";
    
} elsif ($opt_t eq "antidonor_gtgc") {
    print "const Genomecomp_T antidonor_gtgc_bits[] =\n";

} elsif ($opt_t eq "antiacceptor_ag") {
    print "const Genomecomp_T antiacceptor_ag_bits[] =\n";

} elsif ($opt_t eq "antidonor_at") {
    print "const Genomecomp_T antidonor_at_bits[] =\n";

} elsif ($opt_t eq "antiacceptor_ac") {
    print "const Genomecomp_T antiacceptor_ac_bits[] =\n";

} else {
    die "Unrecognized value $opt_t for -t";
}
print "{";

for ($word = 0; $word < 65536; $word++) {
    $nts = get_nts($word);
    if ($opt_t eq "donor_gtgc") {
	$pos = donor_gtgc_pos($nts);
    } elsif ($opt_t eq "acceptor_ag") {
	$pos = acceptor_ag_pos($nts);

    } elsif ($opt_t eq "donor_at") {
	$pos = donor_at_pos($nts);
    } elsif ($opt_t eq "acceptor_ac") {
	$pos = acceptor_ac_pos($nts);

    } elsif ($opt_t eq "antidonor_gtgc") {
	$pos = antidonor_gtgc_pos($nts);
    } elsif ($opt_t eq "antiacceptor_ag") {
	$pos = antiacceptor_ag_pos($nts);

    } elsif ($opt_t eq "antidonor_at") {
	$pos = antidonor_at_pos($nts);
    } elsif ($opt_t eq "antiacceptor_ac") {
	$pos = antiacceptor_ac_pos($nts);

    } else {
	die "Unrecognized value $opt_t for -t";
    }
    $value = make_value($pos);
    if (defined($opt_9)) {
	printf ("0x%04X\t",$word);
	print join("",@ {$nts}) . "\t";
	printf ("0x%03X\t",$value);
	printf join(",",@ {$pos}) . "\n";

    } else {
	if ($col++ == 16) {
	    print "\n ";
	    $col = 1;
	}
	printf ("0x%03X,",$value);
    }
}

print "\n";
print "};\n\n\n";

exit;


sub get_nts {
    my ($word) = @_;
    my @nts = ();

    for ($i = 0; $i < 8; $i++) {
	$nt = $word & 0x03;
	if ($nt == 0) {
	    push @nts,"A";
	} elsif ($nt == 1) {
	    push @nts,"C";
	} elsif ($nt == 2) {
	    push @nts,"G";
	} elsif ($nt == 3) {
	    push @nts,"T";
	} else {
	    die;
	}
	$word = $word >> 2;
    }
    return \@nts;
}


# For debugging
sub make_mer {
    my ($pos) = @_;
    my @newparts = ();

    if ($pos == 1) {
	push @newparts,"A";
	push @newparts,"C";
	push @newparts,"G";
	push @newparts,"T";
    } else {
	$parts = make_mer($pos-1);
	foreach $part (@ {$parts}) {
	    # Need to prepend letter because nts are left to right, while bits are right to left
	    push @newparts,"A" . $part;
	    push @newparts,"C" . $part;
	    push @newparts,"G" . $part;
	    push @newparts,"T" . $part;
	}
    }
    # print STDERR "At pos $pos, returning " . join(" ",@newparts) . "\n";
    return \@newparts;
}


sub make_value {
    my ($pos) = @_;
    my $value = 0;
    
    foreach $i (@ {$pos}) {
	$value += (1 << $i);
    }
    return $value;
}


sub donor_gt_pos {
    my ($nts) = @_;
    my @pos = ();

    if ($ {$nts}[0] eq 'T') {
	push @pos,0;
    }
    for ($i = 1; $i <= 7; $i++) {
	if ($ {$nts}[$i-1] eq 'G' && $ {$nts}[$i] eq 'T') {
	    push @pos,$i;
	}
    }
    if ($ {$nts}[7] eq 'G') {
	push @pos,8;
    }

    return \@pos;
}

# Sense G[TC]
sub donor_gtgc_pos {
    my ($nts) = @_;
    my @pos = ();

    if ($ {$nts}[0] eq 'T' || $ {$nts}[0] eq 'C') {
	push @pos,0;
    }
    for ($i = 1; $i <= 7; $i++) {
	if ($ {$nts}[$i-1] eq 'G' && ($ {$nts}[$i] eq 'T' || $ {$nts}[$i] eq 'C')) {
	    push @pos,$i;
	}
    }
    if ($ {$nts}[7] eq 'G') {
	push @pos,8;
    }

    return \@pos;
}

sub donor_at_pos {
    my ($nts) = @_;
    my @pos = ();

    if ($ {$nts}[0] eq 'T') {
	push @pos,0;
    }
    for ($i = 1; $i <= 7; $i++) {
	if ($ {$nts}[$i-1] eq 'A' && $ {$nts}[$i] eq 'T') {
	    push @pos,$i;
	}
    }
    if ($ {$nts}[7] eq 'A') {
	push @pos,8;
    }

    return \@pos;
}


sub acceptor_ag_pos {
    my ($nts) = @_;
    my @pos = ();

    if ($ {$nts}[0] eq 'G') {
	push @pos,0;
    }
    for ($i = 1; $i <= 7; $i++) {
	if ($ {$nts}[$i-1] eq 'A' && $ {$nts}[$i] eq 'G') {
	    push @pos,$i;
	}
    }
    if ($ {$nts}[7] eq 'A') {
	push @pos,8;
    }

    return \@pos;
}


sub acceptor_ac_pos {
    my ($nts) = @_;
    my @pos = ();

    if ($ {$nts}[0] eq 'C') {
	push @pos,0;
    }
    for ($i = 1; $i <= 7; $i++) {
	if ($ {$nts}[$i-1] eq 'A' && $ {$nts}[$i] eq 'C') {
	    push @pos,$i;
	}
    }
    if ($ {$nts}[7] eq 'A') {
	push @pos,8;
    }

    return \@pos;
}


# Antisense GT => AC
sub antidonor_gt_pos {
    my ($nts) = @_;
    my @pos = ();

    if ($ {$nts}[0] eq 'C') {
	push @pos,0;
    }
    for ($i = 1; $i <= 7; $i++) {
	if ($ {$nts}[$i-1] eq 'A' && $ {$nts}[$i] eq 'C') {
	    push @pos,$i;
	}
    }
    if ($ {$nts}[7] eq 'A') {
	push @pos,8;
    }

    return \@pos;
}

# Antisense G[TC] => [AG]C
sub antidonor_gtgc_pos {
    my ($nts) = @_;
    my @pos = ();

    if ($ {$nts}[0] eq 'C') {
	push @pos,0;
    }
    for ($i = 1; $i <= 7; $i++) {
	if (($ {$nts}[$i-1] eq 'A' || $ {$nts}[$i-1] eq 'G') && $ {$nts}[$i] eq 'C') {
	    push @pos,$i;
	}
    }
    if ($ {$nts}[7] eq 'A' || $ {$nts}[7] eq 'G') {
	push @pos,8;
    }

    return \@pos;
}


# Antisense AT => AT
sub antidonor_at_pos {
    my ($nts) = @_;
    my @pos = ();

    if ($ {$nts}[0] eq 'T') {
	push @pos,0;
    }
    for ($i = 1; $i <= 7; $i++) {
	if ($ {$nts}[$i-1] eq 'A' && $ {$nts}[$i] eq 'T') {
	    push @pos,$i;
	}
    }
    if ($ {$nts}[7] eq 'A') {
	push @pos,8;
    }

    return \@pos;
}


# Antisense AG => CT
sub antiacceptor_ag_pos {
    my ($nts) = @_;
    my @pos = ();

    if ($ {$nts}[0] eq 'T') {
	push @pos,0;
    }
    for ($i = 1; $i <= 7; $i++) {
	if ($ {$nts}[$i-1] eq 'C' && $ {$nts}[$i] eq 'T') {
	    push @pos,$i;
	}
    }
    if ($ {$nts}[7] eq 'C') {
	push @pos,8;
    }

    return \@pos;
}

# Antisense AC => GT
sub antiacceptor_ac_pos {
    my ($nts) = @_;
    my @pos = ();

    if ($ {$nts}[0] eq 'T') {
	push @pos,0;
    }
    for ($i = 1; $i <= 7; $i++) {
	if ($ {$nts}[$i-1] eq 'G' && $ {$nts}[$i] eq 'T') {
	    push @pos,$i;
	}
    }
    if ($ {$nts}[7] eq 'G') {
	push @pos,8;
    }

    return \@pos;
}
*/



const Genomecomp_T donor_gtgc_bits[] =
{0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
};


const Genomecomp_T acceptor_ag_bits[] =
{0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x12A,0x128,0x129,0x128,0x128,0x128,0x129,0x128,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x12A,0x128,0x129,0x128,0x128,0x128,0x129,0x128,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x14A,0x148,0x149,0x148,0x148,0x148,0x149,0x148,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x14A,0x148,0x149,0x148,0x148,0x148,0x149,0x148,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x152,0x150,0x151,0x150,0x150,0x150,0x151,0x150,
 0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x152,0x150,0x151,0x150,0x150,0x150,0x151,0x150,
 0x154,0x154,0x155,0x154,0x150,0x150,0x151,0x150,0x152,0x150,0x151,0x150,0x150,0x150,0x151,0x150,
 0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x152,0x150,0x151,0x150,0x150,0x150,0x151,0x150,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x14A,0x148,0x149,0x148,0x148,0x148,0x149,0x148,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x14A,0x148,0x149,0x148,0x148,0x148,0x149,0x148,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x12A,0x128,0x129,0x128,0x128,0x128,0x129,0x128,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x12A,0x128,0x129,0x128,0x128,0x128,0x129,0x128,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x054,0x054,0x055,0x054,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x094,0x094,0x095,0x094,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x094,0x094,0x095,0x094,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A4,0x0A4,0x0A5,0x0A4,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A4,0x0A4,0x0A5,0x0A4,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A8,0x0A8,0x0A9,0x0A8,0x0A8,0x0A8,0x0A9,0x0A8,0x0AA,0x0A8,0x0A9,0x0A8,0x0A8,0x0A8,0x0A9,0x0A8,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A4,0x0A4,0x0A5,0x0A4,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A4,0x0A4,0x0A5,0x0A4,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A2,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x094,0x094,0x095,0x094,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x094,0x094,0x095,0x094,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x092,0x090,0x091,0x090,0x090,0x090,0x091,0x090,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x08A,0x088,0x089,0x088,0x088,0x088,0x089,0x088,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x084,0x084,0x085,0x084,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x082,0x080,0x081,0x080,0x080,0x080,0x081,0x080,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x054,0x054,0x055,0x054,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x054,0x054,0x055,0x054,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
};


const Genomecomp_T donor_at_bits[] =
{0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x12A,0x128,0x128,0x129,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x12A,0x128,0x128,0x129,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x12A,0x128,0x128,0x129,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x14A,0x148,0x148,0x149,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x14A,0x148,0x148,0x149,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x14A,0x148,0x148,0x149,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x152,0x150,0x150,0x151,
 0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x152,0x150,0x150,0x151,
 0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x152,0x150,0x150,0x151,
 0x154,0x154,0x154,0x155,0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x152,0x150,0x150,0x151,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x14A,0x148,0x148,0x149,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x144,0x144,0x144,0x145,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x142,0x140,0x140,0x141,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x12A,0x128,0x128,0x129,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x124,0x124,0x124,0x125,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x122,0x120,0x120,0x121,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x114,0x114,0x114,0x115,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x112,0x110,0x110,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x10A,0x108,0x108,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x104,0x104,0x104,0x105,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x102,0x100,0x100,0x101,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x02A,0x028,0x028,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x02A,0x028,0x028,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x02A,0x028,0x028,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x024,0x024,0x024,0x025,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x022,0x020,0x020,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x04A,0x048,0x048,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x04A,0x048,0x048,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x04A,0x048,0x048,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x052,0x050,0x050,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x052,0x050,0x050,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x052,0x050,0x050,0x051,
 0x054,0x054,0x054,0x055,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x052,0x050,0x050,0x051,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x04A,0x048,0x048,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x044,0x044,0x044,0x045,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x042,0x040,0x040,0x041,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x014,0x014,0x014,0x015,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x012,0x010,0x010,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x00A,0x008,0x008,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x004,0x004,0x004,0x005,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x002,0x000,0x000,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x00