package com.sun.enterprise.tools.verifier.tests.ejb.ias.resource;
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ResourceEnvRef;
import com.sun.enterprise.tools.common.dd.DefaultResourcePrincipal;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;

/** ejb [0,n]
 *   resource-env-ref [0,n]
 *       resource-env-ref-name [String]
 *       jndi-name [String]
 *
 * The jndi-name tag specifies the jndi name to which the resource environment reference
 * name is binded.
 *
 * The value of this elemnet should not be null and should start
 * with jms/
 *
 * @author Irfan Ahmed
 */
public class ASEjbREnvRefJndiName extends ASEjbResEnvRef { 

    public Result check(EjbDescriptor descriptor) 
    {
	SunEjbJar ejbJar = descriptor.getEjbBundleDescriptor().getIasEjbObject();
        boolean oneFailed = false;
        
        if(ejbJar!=null)
        {
            getEjb(descriptor,ejbJar);
            if(resRefs.length > 0)
            {
                for(int j=0;j<resRefs.length;j++)
                {
                    String refName = resRefs[j].getResourceEnvRefName();
                    String refJndiName = resRefs[j].getJndiName();
                    try
                    {
                        JmsDestinationReferenceDescriptor resDesc = descriptor.getJmsDestinationReferenceByName(refName);
                        String type = resDesc.getRefType();
                        if(type.indexOf("javax.jms")>-1) //jms resource
                        {
                            if(refJndiName.startsWith("jms/"))
                                result.passed(smh.getLocalString(getClass().getName()+".passed1",
                                    "PASSED [AS-EJB res-env-ref] : jndi-name {0} is valid", new Object[]{refJndiName}));
                            else
                                result.failed(smh.getLocalString(getClass().getName()+".failed4",
                                    "FAILED [AS-EJB res-env-ref] : jndi-name {0} has invalid JNDI naming Scheme. " + 
                                    "JMS resources should have jndi-name starting with jms/",
                                    new Object[]{refJndiName}));
                        }
                    }
                    catch(IllegalArgumentException iex)
                    {
                        result.failed(smh.getLocalString(getClass().getName()+".failed",
                            "FAILED [AS-EJB res-env-ref] : res-ref with res-ref-name {0} is not defined in the ejb-jar.xml",
                            new Object[]{refName}));
                    }
                }
            }
            else
            {
                 result.notApplicable(smh.getLocalString
                         (getClass().getName() + ".notApplicable",
                          "{0} Does not define any resource-env-ref Elements",
                          new Object[] {descriptor.getName()}));
            }
        }
        else
        {
            result.addErrorDetails(smh.getLocalString
                 (getClass().getName() + ".notRun",
                  "NOT RUN [AS-EJB] : Could not create an SunEjbJar object"));
        }
        return result;
    }
}

