package com.sun.enterprise.tools.verifier.tests.ejb.ias;

/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

import com.sun.enterprise.tools.common.dd.*;
import com.sun.enterprise.tools.common.dd.ejb.*;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;


/** ejb [0,n]
 *    mdb-connection-factory ?
 *        jndi-name [String]
 *        default-resource-principal ?
 *            name [String]
 *            password [String]
 *
 * The mdb-connection-factory specifies the connection factory associated with
 * an MDB
 * @author Irfan Ahmed
 */
public class ASEjbMDBConnFactory extends EjbTest implements EjbCheck { 

    public Result check(EjbDescriptor descriptor) 
    {
	Result result = getInitializedResult();
	ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);

        SunEjbJar ejbJar = descriptor.getEjbBundleDescriptor().getIasEjbObject();
        boolean oneFailed = false;
        boolean oneWarn = false;
        if(ejbJar!=null)
        {
            Ejb testCase = getEjb(descriptor.getName(),ejbJar);
            MdbConnectionFactory mdbConnFac = testCase.getMdbConnectionFactory();
            if(mdbConnFac != null)
            {
                String jndiName = mdbConnFac.getJndiName();
                if(jndiName.length()==0)
                {
                    oneFailed = true;
                    result.failed(smh.getLocalString(getClass().getName()+".failed",
                        "FAILED [AS-EJB mdb-connection-factory] : jndi-name cannot be an empty string"));
                }
                else
                {
                    if(jndiName.startsWith("jms/"))
                    {
                        result.passed(smh.getLocalString(getClass().getName()+".passed",
                            "PASSED [AS-EJB mdb-connection-factory] : jndi-name is {0}",new Object[]{jndiName}));
                    }
                    else
                    {
                        oneWarn = true;
                        result.warning(smh.getLocalString(getClass().getName()+".warning",
                            "WARNING [AS-EJB mdb-connection-factory] : jndi-name {0} should start with jms/",
                            new Object[]{jndiName}));
                    }
                }
                
                DefaultResourcePrincipal defPrinci = mdbConnFac.getDefaultResourcePrincipal();
                if(defPrinci != null)
                {
                    String name = defPrinci.getName();
                    if(name.length()==0)
                    {
                        oneFailed = true;
                        result.failed(smh.getLocalString(getClass().getName()+".failed1",
                            "FAILED [AS-EJB default-resource-principal] : name cannot be an empty string"));
                    }
                    else
                    {
                        result.passed(smh.getLocalString(getClass().getName()+".passed1",
                            "PASSED [AS-EJB default-resource-principal] : name is {0}",new Object[]{name}));
                    }

                    String password = defPrinci.getPassword();
                    if(password.length()==0)
                    {
                        // <addition> srini@sun.com
                        //oneFailed = true;
                        //result.failed(smh.getLocalString(getClass().getName()+".failed2",
                        // "FAILED [AS-EJB default-resource-principal] : password cannot be an empty string"));
                        result.warning(smh.getLocalString(getClass().getName()+".warning2",
                         "WARNING [AS-EJB default-resource-principal] : password is an empty string"));
                        // </addition>
                    }
                    else
                    {
                        result.passed(smh.getLocalString(getClass().getName()+".passed2",
                            "PASSED [AS-EJB default-resource-principal] : password is  {0}",new Object[]{password}));
                    }
                }
                else
                {
                    result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                        "NOT APPLICABLE [AS-EJB mdb-connection-factory] : default-resource-prncipal element is not defined"));
                }
            }
            else
            {
                if(descriptor instanceof EjbMessageBeanDescriptor)
                {
                    EjbMessageBeanDescriptor mdbDesc = (EjbMessageBeanDescriptor)descriptor;
                    if(mdbDesc.hasTopicDest() && mdbDesc.hasDurableSubscription())
                    {
                        oneFailed = true;
                        result.failed(smh.getLocalString(getClass().getName()+".failed3",
                            "FAILED [AS-EJB ejb] : mdb-connection-factory has to be defined for an MDB with destination-type " + 
                            "as Topic and subscription-durability as Durable"));
                    }
                    else
                    {
                        oneWarn = true;
                        result.warning(smh.getLocalString(getClass().getName()+".warning1",
                            "WARNING [AS-EJB ejb] : mdb-connection-factory should be defined for a Message Driven Bean"));
                    }
                }
                else
                {
                    result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable1",
                        "NOT APPLICABLE [AS-EJB ejb] : mdb-connection-factory element is not defined"));
                }
            }
            if(oneFailed)
                result.setStatus(Result.FAILED);
            else if(oneWarn)
                result.setStatus(Result.WARNING);
        }
        else
        {
            result.addErrorDetails(smh.getLocalString
                 (getClass().getName() + ".notRun",
                  "NOT RUN [AS-EJB] : Could not create an SunEjbJar object"));
        }
        return result;
    }
}
