/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ApplicationRef.java
 *
 * Created on April 12, 2004, 3:37 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Attr;

public class ResourceRef extends GenericElement {
    
    /** Creates a new instance of ApplicationRef */
    public ResourceRef() {
    }
    /**
     * element - resource-ref
     * parentSource - server or cluster
     * parentResult - server or cluster
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        if(parentSource.getTagName().equals("cluster")){
            super.transform(element,parentSource,parentResult);
        }else{
            // If parent is server instead of cluster, the GenericResource adds resource ref to target server for AS7.x source
            if(super.commonInfoModel.getSourceVersion().equals(com.sun.enterprise.tools.upgrade.common.UpgradeConstants.VERSION_7X))
                return;
            //Added for CR 6363168
            if(element.getAttribute("ref").equals("jdbc/PointBase"))
                return;
            super.transform(element,parentSource,parentResult);
        }
    }
    protected java.util.List getInsertElementStructure(Element element, Element parentEle){
        // resource-ref is an element in cluster and server.  In cluster there are 3 elements after this.  
        // In server there are only two after this.
        java.util.List insertStrucure = com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper.getMapper().getInsertElementStructure(element.getTagName());
        String parentName = parentEle.getTagName();
        if(parentName != null){
            if(parentName.equals("cluster")){
                insertStrucure.add(0,"application-ref");
            }
        }
        return insertStrucure;
    }
    
}
