/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * GenericContainer.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

public class GenericElement extends BaseElement {
    
    /** Creates a new instance of Element */
    public GenericElement() {
    }
    /**
     * element - any-element
     * parentSource - parent of any-element
     * parentResult - result parent of any-element peer
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        String elementTagName = element.getTagName();
        //Added for CR 6363745
        if(elementTagName.equals("message-security-config"))
            return;
        NodeList resultElements = parentResult.getElementsByTagName(elementTagName);
        Element resultElement = null;
        String key = this.getKeyToCompare(elementTagName);
        if(key != null){
            for(int lh =0; lh < resultElements.getLength(); lh++){
                Element itElement = ((Element)resultElements.item(lh));
                // Compare one key attribute
                if((element.getAttribute(key)).equals(((Element)resultElements.item(lh)).getAttribute(key))){
                    resultElement = (Element)resultElements.item(lh);
                    break;
                }
            }
        }else{
            // If the key is not defined then there is only one element.
            if(resultElements.getLength() != 0){
                resultElement = (Element)resultElements.item(0);
            }
        }
        if(resultElement == null){
            resultElement = parentResult.getOwnerDocument().createElement(elementTagName);
            this.transferAttributes(element, resultElement, this.getNonTransferList(element));
            this.appendElementToParent(parentResult,resultElement);  
        }else {       
            this.transferAttributes(element, resultElement, this.getNonTransferList(element));
        } 
        super.transform(element,  parentSource, resultElement);  
    }
    /*
     * Subclasses whichever want to provide a list of NonTransferList
     */
    protected java.util.List getNonTransferList(Element element){
        return null;
    }
    
}
