/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.logging;

import java.io.*;
import java.util.logging.*;
import com.sun.enterprise.tools.upgrade.common.*;

/**
 *
 * author : Servesh Singh
 *
 */

public class LogService {

    public static final String UPGRADE_LOGGER="com.sun.enterprise.tools.upgrade";
    public static final String UPGRADE_CLI_LOGGER="com.sun.enterprise.tools.upgrade.cli";
    public static final String UPGRADE_CERTCONVERSION_LOGGER="com.sun.enterprise.tools.upgrade.certconversion";
    private static LogFormatter formatter;
    private static FileHandler loghandler;

    public static void initialize(String fileName) throws IOException{
	LogManager.getLogManager().reset();
	formatter = new LogFormatter();
    boolean append = true;  
    int limit = 1000000;    
    loghandler = new FileHandler(fileName,limit,1,append);    
	loghandler.setLevel( Level.ALL );
	loghandler.setFormatter(formatter);
    }

    public static Logger getLogger(String name) {
	Logger logger = Logger.getLogger(name);
        // TODO: Read a property from the file or System property and set this level.
        // This will be useful for better debugging.
        //logger.setLevel( Level.ALL );
	Handler[] h = logger.getHandlers();
	for (int i = 0; i < h.length; i++) {
	    logger.removeHandler(h[i]);
	}
	logger.addHandler(loghandler);
	return logger;
    }

    public static void addLogMessageListener(LogMessageListener listener){
    formatter.addLogMessageListener(listener);
    }

    public static void removeLogMessageListener(LogMessageListener listener){
	formatter.removeLogMessageListener(listener);
    }

}

